package com.biz.crm.user.controller;

import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelWeChatReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelWeChatRespVo;
import com.biz.crm.user.service.MdmUserRelWeChatService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Objects;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户关联微信
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@RestController
@RequestMapping("/mdmUserRelWeChatController")
@Api(tags = "MDM-用户管理-关联微信")
public class MdmUserRelWeChatController {

  @Autowired
  private MdmUserRelWeChatService mdmUserRelWeChatService;

  @ApiOperation(value = "查询用户关联的微信列表", httpMethod = "POST")
  @PostMapping("/findUserRelWeChatList")
  public Result<List<MdmUserRelWeChatRespVo>> findUserRelWeChatList(@RequestBody MdmUserRelWeChatReqVo reqVo) {
    return Result.ok(mdmUserRelWeChatService.findUserRelWeChatList(reqVo));
  }

  @ApiOperation(value = "解绑指定关联的微信", httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "ids", value = "用户关联微信表的id集合", required = true, paramType = "body")
  })
  @PostMapping("/unbindUserWeChat")
  public Result unbindUserWeChat(@RequestBody List<String> ids) {
    mdmUserRelWeChatService.unbindByIds(ids);
    return Result.ok("解绑成功");
  }

  @ApiOperation(value = "绑定指定关联的微信", httpMethod = "POST")
  @PostMapping("/bindUserWeChat")
  public Result bindUserWeChat(@RequestParam(value = "openId") String openId, @RequestParam(value = "fromType") String fromType) {
    MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
    UserRedis user = UserUtils.getUser();
    bindReq.setUserName(user.getUsername());
    bindReq.setOriginModule(fromType);
    bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
    bindReq.setOpenId(openId);
    mdmUserRelWeChatService.bind(bindReq);
    return Result.ok("绑定成功");
  }

  @ApiOperation(value = "绑定指定关联的微信", httpMethod = "POST")
  @PostMapping("/bindUserWeChatVerificationPhone")
  public Result bindUserWeChatVerificationPhone(@RequestParam(value = "openId") String openId, @RequestParam(value = "phone") String phone, @RequestParam(value = "code") String code) {
    MdmUserRelWeChatReqVo bindReq = new MdmUserRelWeChatReqVo();
    UserRedis user = UserUtils.getUser();
    bindReq.setUserName(user.getUsername());
    bindReq.setOriginModule("applet_terminal");
    bindReq.setLoginStatus(YesNoEnum.yesNoEnum.ONE.getValue());
    bindReq.setOpenId(openId);
    mdmUserRelWeChatService.bindUserWeChatVerificationPhone(bindReq, phone, code);
    return Result.ok("绑定成功");
  }
}
