package com.biz.crm.user.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationCustomerService;
import com.biz.crm.user.service.MdmUserRelationCustomerService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/mdmUserRelationCustomerController")
@Api(tags = "MDM-用户管理(企业用户)-关联客户")
@CrmGlobalLog
public class MdmUserRelationCustomerController {

    @Autowired
    private MdmUserRelationCustomerService mdmUserRelationCustomerService;
    @Autowired
    private MdmPositionRelationCustomerService mdmPositionRelationCustomerService;

    @ApiOperation(value = "查询未关联任何用户的客户")
    @PostMapping("/findCustomerNotRelateAnyUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationCustomerPageRespVo>> findCustomerNotRelateAnyUser(@RequestBody MdmUserRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmUserRelationCustomerService.findCustomerNotRelateAnyUser(reqVo));
    }

    @ApiOperation(value = "查询未关联当前用户的客户", notes = "userName必传")
    @PostMapping("/findCustomerNotRelateCurUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationCustomerPageRespVo>> findCustomerNotRelateCurUser(@RequestBody MdmUserRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmUserRelationCustomerService.findCustomerNotRelateCurUser(reqVo));
    }

    @ApiOperation(value = "查询已关联当前用户的客户", notes = "userName必传")
    @PostMapping("/findCustomerHasRelateCurUser")
    @CrmDictMethod
    public Result<PageResult<MdmUserRelationCustomerPageRespVo>> findCustomerHasRelateCurUser(@RequestBody MdmUserRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmUserRelationCustomerService.findCustomerHasRelateCurUser(reqVo));
    }

    @ApiOperation(value = "添加关联", notes = "customerCodeList和positionCode必传")
    @PostMapping("/bindRelation")
    public Result bindRelation(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        mdmPositionRelationCustomerService.bindRelation(reqVo.getCustomerCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "替换关联职位", notes = "（ids和positionCode必传）")
    @PostMapping("/replaceCustomerPosition")
    public Result replaceCustomerPosition(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        mdmPositionRelationCustomerService.replaceCustomerPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "解除关联", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "关联关系id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindRelation")
    public Result unbindRelation(@RequestBody List<String> ids) {
        mdmPositionRelationCustomerService.unbindRelation(ids);
        return Result.ok();
    }

}
