package com.biz.crm.user.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.user.req.MdmUserLoginLogReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.user.model.MdmUserLoginLogEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 用户登录日志表
 *
 * @author Tao.Chen
 * @date 2021-03-18 21:38:20
 */
public interface MdmUserLoginLogMapper extends BaseMapper<MdmUserLoginLogEntity> {

    /**
     * 列表
     *
     * @param page
     * @param mdmUserLoginLogReqVo
     * @return
     */
    List<MdmUserLoginLogRespVo> findList(Page<MdmUserLoginLogRespVo> page, @Param("vo") MdmUserLoginLogReqVo mdmUserLoginLogReqVo);

    /**
     * 精确查询日志列表
     *
     * @param page
     * @param mdmUserLoginLogReqVo
     * @return
     */
    List<MdmUserLoginLogRespVo> findUserLoginLogList(Page<MdmUserLoginLogRespVo> page, @Param("vo") MdmUserLoginLogReqVo mdmUserLoginLogReqVo);

}
