package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmConsumerEditReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeCurrentCustomerReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserEditReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmConsumerRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmCustomerUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.model.MdmUserEntity;

import java.util.List;

/**
 * @Description:消费用户信息表接口
 * @project：crm-core
 * @package：com.biz.crm.user.service
 * @author：longyu
 * @create：2020/12/29 10:43
 */
public interface MdmConsumerUserService extends IService<MdmUserEntity> {

    /**
     * 列表
     *
     * @param reqVo
     * @return PageResult<MdmUserRespVo>
     */
    PageResult<MdmCustomerUserPageRespVo> findList(MdmCustomerUserPageReqVo reqVo);

    /**
     * 获取客户用户编辑页面详情
     *
     * @param id
     * @param userName
     * @return
     */
    MdmConsumerRespVo query(String id, String userName);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmConsumerEditReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    void update(MdmConsumerEditReqVo reqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

}
