package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.*;
import com.biz.crm.nebular.mdm.user.resp.*;
import com.biz.crm.user.model.MdmUserEntity;

import java.util.List;

/**
 * 客户用户信息表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
public interface MdmCustomerUserService extends IService<MdmUserEntity> {

    /**
     * 列表
     *
     * @param reqVo
     * @return PageResult<MdmUserRespVo>
     */
    PageResult<MdmCustomerUserPageRespVo> findList(MdmCustomerUserPageReqVo reqVo);

    /**
     * 获取客户用户编辑页面详情
     *
     * @param id
     * @param userName
     * @return
     */
    MdmUserRespVo query(String id, String userName);

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    void save(MdmUserEditReqVo reqVo);

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    void update(MdmUserEditReqVo reqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 客户用户切换当前客户
     *
     * @param reqVo
     */
    void changeUserCurrentCustomer(MdmUserChangeCurrentCustomerReqVo reqVo);

    /**
     * 查询客户用户分页弹窗列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmUserSelectRespVo> findCustomerUserSelectPageList(MdmUserSelectReqVo reqVo);

    /**
     * 查询经销商关联的企业用户
     *
     * @param reqVo
     * @return
     */
    List<MdmUserRespVo> findCustomerRelCustomerUserList(MdmCustomerRelCustomerUserReqVo reqVo);

    /**
     * 查询客户用户下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmUserSelectRespVo> findCustomerUserSelectList(MdmUserSelectReqVo reqVo);

    /**
     * 查询未关联任何权限角色的客户用户列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelAnyRole(MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 查询未关联当前权限角色的客户用户列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserNotRelCurRole(MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 查询已关联当前权限角色的客户用户列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelRolePageRespVo> findCustomerUserHasRelCurRole(MdmCustomerUserRelRolePageReqVo reqVo);

    /**
     * 绑定客户用户与权限角色
     *
     * @param reqVo
     */
    void bindUserRelRole(MdmCustomerUserRelRoleReqVo reqVo);

    /**
     * 替换客户用户关联的权限角色
     *
     * @param reqVo
     */
    void replaceUserRelRole(MdmCustomerUserRelRoleReqVo reqVo);

    /**
     * 解除客户用户关联的权限角色
     *
     * @param ids
     */
    void unbindUserRelRole(List<String> ids);

    /**
     * 查询未关联任何客户用户的终端列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelAnyCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前客户用户的终端列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalNotRelCurCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前客户用户的终端列表
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmCustomerUserRelTerminalPageRespVo> findTerminalHasRelCurCustomerUser(MdmCustomerUserRelTerminalPageReqVo reqVo);

    /**
     * 绑定终端和客户用户
     *
     * @param reqVo
     */
    void bindCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo);

    /**
     * 替换终端的客户用户
     *
     * @param reqVo
     */
    void replaceCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo);

    /**
     * 解除客户用户关联的终端
     *
     * @param reqVo
     */
    void unbindCustomerUserRelTerminal(MdmCustomerUserRelTerminalReqVo reqVo);

}

