package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.user.req.MdmUserLoginLogReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.user.model.MdmUserLoginLogEntity;

/**
 * 用户登录日志表接口
 *
 * @author Tao.Chen
 * @date 2021-03-18 21:38:20
 */
public interface MdmUserLoginLogService extends IService<MdmUserLoginLogEntity> {

    /**
     * 列表
     *
     * @param mdmUserLoginLogReqVo
     * @return PageResult<MdmUserLoginLogRespVo>
     */
    PageResult<MdmUserLoginLogRespVo> findList(MdmUserLoginLogReqVo mdmUserLoginLogReqVo);

    /**
     * 获取上一次登录日志
     *
     * @param userName 用户账号
     * @param fromType 登录来源
     * @return
     */
    MdmUserLoginLogRespVo getLastLoginLog(String userName, String fromType);

}

