package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelCustomerRespVo;
import com.biz.crm.user.model.MdmUserRelCustomerEntity;

import java.util.List;
import java.util.Map;

/**
 * 客户用户与客户关联表接口
 *
 * @author Tao.Chen
 * @date 2021-04-19 14:55:59
 */
public interface MdmUserRelCustomerService extends IService<MdmUserRelCustomerEntity> {

    void add(String userName, String customerCode);

    @Deprecated
    void add(String userName, String customerCode, String currentFlag);

    void add(String userName, List<String> customerCodeList);

    void add(List<String> userNameList, String customerCode);

    void del(String userName, String customerCode);

    void del(String userName, List<String> customerCodeList);

    void del(List<String> userNameList, String customerCode);

    void delByUserName(String userName);

    void delByUserName(List<String> userNameList);

    void delByCustomerCode(String customerCode);

    void delByCustomerCode(List<String> customerCodeList);

    void setUniqueCurrentCustomerIfExist(String userName, String customerCode);

    List<String> findCustomerCodeListByUserName(String userName);

    List<MdmUserRelCustomerRespVo> findCustomerListByUserName(String userName);

    Map<String, List<String>> getCustomerCodeListGroupByUserNameList(List<String> userNameList);

    List<String> findUserNameListByCustomerCode(String customerCode);

    List<String> findUserNameListByCustomerCodeList(List<String> customerCodeList);

}

