package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.user.model.MdmUserRelRoleEntity;

import java.util.List;

/**
 * 用户与权限角色关联表接口
 *
 * @author Tao.Chen
 * @date 2021-04-19 14:55:59
 */
public interface MdmUserRelRoleService extends IService<MdmUserRelRoleEntity> {

    void add(String userName, String roleCode);

    void add(String userName, List<String> roleCodeList);

    void add(List<String> userNameList, String roleCode);

    void del(String userName, String roleCode);

    void del(String userName, List<String> roleCodeList);

    void del(List<String> userNameList, String roleCode);

    void delByUserName(String userName);

    void delByUserName(List<String> userNameList);

    void delByRoleCode(String roleCode);

    void delByRoleCode(List<String> roleCodeList);

    List<String> findRoleCodeListByUserName(String userName);

    List<String> findUserNameListByRoleCodeList(List<String> roleCodeList);

    void replaceUserRelRole(List<String> ids, String roleCode);

}

