package com.biz.crm.user.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.user.req.MdmUserTerminalEditReqVo;
import com.biz.crm.user.model.MdmUserRelTerminalEntity;

import java.util.List;
import java.util.Map;

/**
 * @author ql
 * @date 2021/2/4
 * @time 18:17
 * 终端用户和终端关联关系service
 **/
public interface MdmUserRelTerminalService extends IService<MdmUserRelTerminalEntity> {

    void add(String userName, String terminalCode);

    void add(String userName, String terminalCode, String currentFlag);

    void add(String userName, List<MdmUserTerminalEditReqVo> reqVoList);

    void add(List<String> userNameList, String terminalCode);

    void del(String userName, String terminalCode);

    void del(String userName, List<String> terminalCodeList);

    void del(List<String> userNameList, String terminalCode);

    void delByUserName(String userName);

    void delByUserName(List<String> userNameList);

    void delByTerminalCode(String terminalCode);

    void delByTerminalCode(List<String> terminalCodeList);

    void setUniqueCurrentTerminalIfExist(String userName, String terminalCode);

    List<MdmUserRelTerminalEntity> findTerminalCodeListByUserName(String userName);

    Map<String, List<String>> getTerminalCodeListGroupByUserNameList(List<String> userNameList);

}
