package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.LoginFromTypeEnum;
import com.biz.crm.nebular.mdm.user.req.MdmUserLoginLogReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserLoginLogRespVo;
import com.biz.crm.user.mapper.MdmUserLoginLogMapper;
import com.biz.crm.user.model.MdmUserLoginLogEntity;
import com.biz.crm.user.service.MdmUserLoginLogService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * 用户登录日志表接口实现
 *
 * @author Tao.Chen
 * @date 2021-03-18 21:38:20
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmUserLoginLogServiceExpandImpl")
public class MdmUserLoginLogServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmUserLoginLogMapper, MdmUserLoginLogEntity> implements MdmUserLoginLogService {

    @Resource
    private MdmUserLoginLogMapper mdmUserLoginLogMapper;

    @Override
    public PageResult<MdmUserLoginLogRespVo> findList(MdmUserLoginLogReqVo reqVo) {
        Page<MdmUserLoginLogRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmUserLoginLogRespVo> list = mdmUserLoginLogMapper.findList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(x->{
                x.setFromTypeName(LoginFromTypeEnum.getDesc(x.getFromType()));
            });
        }
        return PageResult.<MdmUserLoginLogRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public MdmUserLoginLogRespVo getLastLoginLog(String userName, String fromType) {
        Page<MdmUserLoginLogRespVo> page = new Page<MdmUserLoginLogRespVo>(1L, 1L, false);
        MdmUserLoginLogReqVo reqVo = new MdmUserLoginLogReqVo().setUserName(userName).setFromType(fromType);
        List<MdmUserLoginLogRespVo> list = mdmUserLoginLogMapper.findUserLoginLogList(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            MdmUserLoginLogRespVo loginLogRespVo = list.get(0);
            loginLogRespVo.setFromTypeName(LoginFromTypeEnum.getDesc(loginLogRespVo.getFromType()));
            return loginLogRespVo;
        }
        return null;
    }

}
