package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import com.biz.crm.terminal.service.MdmTerminalSupplyService;
import com.biz.crm.user.mapper.MdmUserRelationTerminalMapper;
import com.biz.crm.user.service.MdmUserRelationTerminalService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
@ConditionalOnMissingBean(name = "MdmUserRelationTerminalServiceExpandImpl")
public class MdmUserRelationTerminalServiceImpl implements MdmUserRelationTerminalService {

    @Resource
    private MdmUserRelationTerminalMapper mdmUserRelationTerminalMapper;
    @Resource
    private MdmTerminalSupplyService mdmTerminalSupplyService;
    @Resource
    private MdmTerminalROrgService mdmTerminalROrgService;


    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateAnyUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page<MdmUserRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = mdmUserRelationTerminalMapper.findTerminalNotRelateAnyUser(page, reqVo);
        setOrgName(list);
        return PageResult.<MdmUserRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalNotRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page<MdmUserRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        Assert.hasText(reqVo.getUserName(), "缺失用户名");
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = mdmUserRelationTerminalMapper.findTerminalNotRelateCurUser(page, reqVo);
        setOrgName(list);
        setPositionCodeName(list);
        return PageResult.<MdmUserRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmUserRelationTerminalPageRespVo> findTerminalHasRelateCurUser(MdmUserRelationTerminalPageReqVo reqVo) {
        Page<MdmUserRelationTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmUserRelationTerminalPageRespVo> list = mdmUserRelationTerminalMapper.findTerminalHasRelateCurUser(page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                item.setId(item.getSupplyId());
            });
        }
        setOrgName(list);
        Assert.hasText(reqVo.getUserName(), "缺失用户名");
        return PageResult.<MdmUserRelationTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    protected void setOrgName(List<MdmUserRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        final Map<String, List<MdmOrgRespVo>> map = mdmTerminalROrgService.findOrgGroupByTerminalCodeList(list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList()));
        list.forEach(item -> {
            if (map.containsKey(item.getTerminalCode())) {
                List<MdmOrgRespVo> orgList = map.get(item.getTerminalCode());
                item.setOrgName(orgList.stream().map(MdmOrgRespVo::getOrgName).collect(Collectors.joining(",")));
            }
        });
    }

    protected void setPositionCodeName(List<MdmUserRelationTerminalPageRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<String> terminalCodeList = list.stream().map(MdmUserRelationTerminalPageRespVo::getTerminalCode).collect(Collectors.toList());
            List<MdmTerminalSupplyVo> terminalSupplyList = mdmTerminalSupplyService.findTerminalSupply(new MdmTerminalVo().setTerminalCodeList(terminalCodeList));
            List<String> positionCodeList = terminalSupplyList.stream().map(MdmTerminalSupplyVo::getPositionCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
                final Map<String, MdmPositionRespVo> positionMap = PositionUtil.getPositionByCodeList(positionCodeList)
                        .stream()
                        .collect(Collectors.toMap(MdmPositionRespVo::getPositionCode, v -> v));
                if (!positionMap.isEmpty()) {
                    final Map<String, List<String>> collect = terminalSupplyList.stream().filter(item -> StringUtils.isNotEmpty(item.getPositionCode())).collect(Collectors.groupingBy(MdmTerminalSupplyVo::getTerminalCode, Collectors.mapping(MdmTerminalSupplyVo::getPositionCode, Collectors.toList())));
                    list.forEach(item -> {
                        if (collect.containsKey(item.getTerminalCode())) {
                            List<String> positionCodeListInThisTerminal = collect.get(item.getTerminalCode());
                            List<MdmPositionRespVo> positionListInThisTerminal = new ArrayList<>();
                            for (String positionCode :
                                    positionCodeListInThisTerminal) {
                                if (positionMap.containsKey(positionCode)) {
                                    positionListInThisTerminal.add(positionMap.get(positionCode));
                                }
                            }
                            item.setPositionCode(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.joining(",")));
                            item.setPositionName(positionListInThisTerminal.stream().map(MdmPositionRespVo::getPositionName).collect(Collectors.joining(",")));
                        }
                    });
                }
            }
        }
    }
}
