package com.biz.crm.utils;

import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * @author zxw
 * @date 2021-05-22 21:49
 **/
public class EsBoolQueryBuilder {

    private final BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();

    private EsBoolQueryBuilder(){}

    public static EsBoolQueryBuilder lambdaQuery() {
        return new EsBoolQueryBuilder();
    }

    public EsBoolQueryBuilder must(boolean flag, Supplier<QueryBuilder> supplier) {
        return predicate(flag, x -> x.must(supplier.get()));
    }

    public EsBoolQueryBuilder should(boolean flag, Supplier<QueryBuilder> supplier) {
        return predicate(flag, x -> x.should(supplier.get()));
    }

    public EsBoolQueryBuilder should(boolean flag,Supplier<QueryBuilder> supplier, int minimumShouldMatch) {
        return predicate(flag, x -> x.should(supplier.get()).minimumShouldMatch(minimumShouldMatch));
    }

    public EsBoolQueryBuilder mustNot(boolean flag, Supplier<QueryBuilder> supplier) {
        return predicate(flag, x -> x.mustNot(supplier.get()));
    }

    public EsBoolQueryBuilder filter(boolean flag, Supplier<QueryBuilder> supplier) {
        return predicate(flag, x -> x.filter(supplier.get()));
    }

    public EsBoolQueryBuilder filter(QueryBuilder queryBuilder) {
        return predicate(true, x -> x.filter(queryBuilder));
    }

    public EsBoolQueryBuilder predicate(boolean flag, Consumer<BoolQueryBuilder> consumer) {
        if (flag) {
            consumer.accept(boolQueryBuilder);
        }
        return this;
    }

    public BoolQueryBuilder build() {
        return boolQueryBuilder;
    }
}
