package com.biz.crm.utils;

import com.biz.crm.base.BusinessException;
import com.maxmind.geoip2.DatabaseReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

import java.io.IOException;
import java.io.InputStream;

public class GeoLiteReader {

    private static volatile DatabaseReader databaseReader;

    private GeoLiteReader() {
    }

    public static DatabaseReader getInstance() {
        if (databaseReader == null) {
            synchronized (GeoLiteReader.class) {
                if (databaseReader == null) {
                    try {
                        Resource resource = new ClassPathResource("/GeoLite2-City.mmdb");
                        InputStream is = resource.getInputStream();
                        databaseReader = new DatabaseReader.Builder(is).build();
                    } catch (IOException e) {
                        e.printStackTrace();
                        throw new BusinessException("查询失败");
                    }
                }
            }
        }
        return databaseReader;
    }

    public static void clear() {
        databaseReader = null;
    }

    @Override
    protected Object clone() {
        return this;
    }
}
