package com.biz.crm.utils;

import com.biz.crm.eunm.mdm.MdmColumnSearchTypeEnum;
import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 动态sql工具类
 * @Author hej
 * @Created Date 2020-12-29
 **/
@Component
public class ProviderUtil {

    @Resource
    private IMdmColumnConfigService iMdmColumnConfigService;

    private static ProviderUtil providerUtil;


    /**
     * 初始化service
     */
    @PostConstruct
    public void init(){
        providerUtil = this;
        providerUtil.iMdmColumnConfigService = this.iMdmColumnConfigService;
    }

    /**
     * 获取当前header的值并得到集合
     *
     * @return
     */
    public static List<MdmColumnConfigRespVo> gainConfigVo() {
        //通过header拿到编码数据
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        //功能编码
        String functionCode = request.getHeader("functionCode");
        //菜单编码
        String menuCode = request.getHeader("menuCode");
        if(StringUtils.isEmpty(functionCode) || StringUtils.isEmpty(menuCode)){
            return null;
        }
        MdmColumnConfigReqVo configReqVo = new MdmColumnConfigReqVo();
        configReqVo.setFunctionCode(functionCode);
        configReqVo.setParentCode(menuCode);
        return providerUtil.iMdmColumnConfigService.listCondition(configReqVo);
    }


    public static List<MdmColumnConfigRespVo> getTestList(){
        //测试
        List<MdmColumnConfigRespVo> vos = new ArrayList<>();
        MdmColumnConfigRespVo vo = new MdmColumnConfigRespVo();
        vo.setField("1f");
        vo.setEntityFieldName("ext1");
        vo.setSearchType("1");
        MdmColumnConfigRespVo vo1 = new MdmColumnConfigRespVo();
        vo1.setField("2f");
        vo1.setEntityFieldName("ext2");
        vo1.setSearchType("0");
        vos.add(vo);
        vos.add(vo1);
        return vos;
    }

    /**
     * sql like拼接百分号
     *
     * @param itself 本体
     * @param mdmProviderEnum
     * @return
     */
    public static String bindPercent(String itself, MdmProviderEnum mdmProviderEnum) {
        if(Objects.isNull(itself)){
            itself = "";
        }
        switch (mdmProviderEnum){
            case SQL_JOIN_LEFT:
                itself = "%".concat(itself);
                break;
            case SQL_JOIN_RIGHT:
                itself = itself.concat("%");
                break;
            case SQL_JOIN_ALL:
                itself = "%".concat(itself).concat("%");
            default:
                break;
        }
        return "'".concat(itself).concat("'");
    }

    /**
     * foreach拼接
     *
     * @param open      开始
     * @param separator 分割符
     * @param close     结束
     * @return
     */
    public static String gainForeach(String open, String separator, String close, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        if(StringUtils.isNotEmpty(open)){
            buffer.append(open);
        }
        if(StringUtils.isEmpty(separator)){
            separator="";
        }
        for (String str : list) {
            buffer.append("'" + str + "'" + separator);
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        if(StringUtils.isNotEmpty(close)){
            buffer.append(close);
        }
        return buffer.toString();
    }

    /**
     * sql拼接
     *
     * @param entityFieldName 字段名
     * @param field           值
     * @param searchType      类型
     * @return
     */
    public static String gainDynamicSql(String entityFieldName, String field, String searchType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(entityFieldName);
        MdmColumnSearchTypeEnum typeEnum = MdmColumnSearchTypeEnum.getEnumByCode(searchType);
        switch (typeEnum) {
            case ACCURATE:
                buffer.append(" = '" + field + "'");
                break;
            case VAGUE:
                buffer.append(" like '%" + field + "%'");
                break;
            //TODO 只能识别全等和模糊
            default:
                break;
        }
        String result = buffer.toString();
        return result.length()==entityFieldName.length()?"":result;
    }

    /**
     * @param cvo   参数集合
     * @param alias 表的别名(若没有则传空)
     * @return
     */
    public static String gainExtendSql(List<MdmColumnConfigRespVo> cvo, String alias) {
        StringBuffer buffer = new StringBuffer();
        //公共ext参数
        cvo.stream()
                .filter(mdm -> StringUtils.isNotEmpty(mdm.getField())
                        && StringUtils.isNotEmpty(mdm.getEntityFieldName())
                        && StringUtils.isNotEmpty(mdm.getSearchType()))
                .forEach(mdm -> {
                    String sql = ProviderUtil.gainDynamicSql(mdm.getEntityFieldName(), mdm.getField(), mdm.getSearchType());
                    if(StringUtils.isNotEmpty(sql)){
                        buffer.append(StringUtils.isEmpty(alias) ? sql : alias.concat(".").concat(sql));
                        buffer.append(" AND ");
                    }
                }
        );
        if (buffer.length() > 3) {
            buffer.delete(buffer.lastIndexOf("AND"), buffer.length());
        }

        return buffer.toString();
    }




}
