/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.config.SecurityUserDetails;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthorizationTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthorizationTokenFilter.class);
    @Autowired
    private RedisService redisService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        UserRedis userRedis;
        Cookie cookie;
        String token = request.getHeader("loginUserToken");
        log.info("token:{}", (Object)token);
        if (token == null && (cookie = CookiesUtil.getCookieByName(request, "loginUserToken")) != null) {
            token = cookie.getValue();
        }
        Object o = this.redisService.get("token:" + token);
        log.info("doFilter:o:{}", o);
        if (o != null && StringUtils.isNotEmpty((String)(userRedis = (UserRedis)o).getUsername()) && SecurityContextHolder.getContext().getAuthentication() == null) {
            SecurityUserDetails userDetails = new SecurityUserDetails(userRedis.getUsername(), new ArrayList());
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

