/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.aop;

import com.biz.crm.aop.CrmAPIDiscard;
import com.biz.crm.base.BusinessException;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class APIDiscardAspect {
    private static final Logger log = LoggerFactory.getLogger(APIDiscardAspect.class);

    @Before(value="@annotation(CrmAPIDiscard)")
    public void doBefore(JoinPoint joinPoint) {
        Class<?> clazz = joinPoint.getTarget().getClass();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        CrmAPIDiscard crmAPIDiscard = method.getAnnotation(CrmAPIDiscard.class);
        String msg = crmAPIDiscard.msg().replace("API_NAME", clazz.getSimpleName() + "." + method.getName());
        throw new BusinessException(msg);
    }
}

