/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import com.biz.crm.util.UUIDGenerator;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookiesUtil {
    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = CookiesUtil.ReadCookieMap(request);
        if (cookieMap.containsKey(name)) {
            Cookie cookie = cookieMap.get(name);
            return cookie;
        }
        return null;
    }

    private static Map<String, Cookie> ReadCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static HttpServletResponse setCookie(HttpServletResponse response, String name, String value, int time) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath("/");
        try {
            URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        response.addCookie(cookie);
        return response;
    }

    public static String getKeyFlag(String userName, String cookFlag) {
        StringBuffer key = new StringBuffer();
        key.append(userName).append("_").append(cookFlag).append(UUIDGenerator.generate().toString().replaceAll("-", ""));
        return key.toString();
    }

    public static void doCoke(HttpServletRequest request, HttpServletResponse response, String userName, String cookFlag) {
        CookiesUtil.setCookie(response, cookFlag, userName, 86400);
    }

    public static void doCoke(HttpServletRequest request, HttpServletResponse response, String userName, String cookFlag, int time) {
        CookiesUtil.setCookie(response, cookFlag, userName, time);
    }
}

