/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.config;

import com.biz.crm.service.RedisService;
import com.biz.crm.util.UserRedis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TokenRenewalUtil {
    private static final Logger log = LoggerFactory.getLogger(TokenRenewalUtil.class);
    private static final String TokenRenewalKey = "TOKEN_RENEWAL_KEY:";
    @Value(value="${crm.token.time:86400}")
    private String overtime;
    @Value(value="${crm.token.renewal:300}")
    private String renewaltime;
    @Autowired
    private RedisService redisService;

    public static String getRenewalKey(String token) {
        return TokenRenewalKey + token;
    }

    public void loginOut(String token) {
        log.info("\u9000\u51fa\u767b\u5f55:" + token + "==>" + token);
        this.redisService.del(new String[]{TokenRenewalUtil.getRenewalKey(token)});
    }

    public void login(String token) {
        log.info("\u767b\u5f55\u8bb0\u5f55token:" + token);
        Object o = this.redisService.get("token:" + token);
        UserRedis userRedis = (UserRedis)o;
        this.redisService.setSeconds(TokenRenewalUtil.getRenewalKey(token), (Object)userRedis, this.getRenewaltime() + this.getTokenTime());
    }

    public void login(String token, long time) {
        log.info("\u767b\u5f55\u8bb0\u5f55token:" + token + "==>" + time);
        Object o = this.redisService.get("token:" + token);
        UserRedis userRedis = (UserRedis)o;
        this.redisService.setSeconds(TokenRenewalUtil.getRenewalKey(token), (Object)userRedis, this.getRenewaltime() + time);
    }

    public UserRedis loginRenewal(String token) {
        if (token == null) {
            return null;
        }
        Object o = this.redisService.get(TokenRenewalKey + token);
        if (o == null) {
            log.info("\u5df2\u8fc7\u671ftoken[" + token + "]");
            return null;
        }
        log.info("\u7eed\u671f:" + token + "==>" + token);
        UserRedis userRedis = (UserRedis)o;
        this.redisService.setSeconds(TokenRenewalUtil.getRenewalKey(token), (Object)userRedis, this.getRenewaltime() + this.getTokenTime());
        this.redisService.setSeconds("token:" + token, (Object)userRedis, this.getTokenTime());
        return userRedis;
    }

    public long getTokenTime() {
        return Long.valueOf(this.overtime);
    }

    public long getRenewaltime() {
        return Long.valueOf(this.renewaltime);
    }
}

