/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rule.utils;

import com.biz.crm.common.ShellResult;
import com.biz.crm.common.param.BaseGroovyShellParam;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.StringUtils;

public class GroovyShellUtil {
    private static final int MAX_CLASS_CACHE = 150;
    private static final Logger log = LoggerFactory.getLogger(GroovyShellUtil.class);

    private static Map<String, Object> buildParam(BaseGroovyShellParam param) {
        Map<String, Object> paramsMap = null == param.getTestParamMap() ? new HashMap<String, Object>() : param.getTestParamMap();
        BeanMap beanMap = BeanMap.create((Object)param);
        for (Object key : beanMap.keySet()) {
            if ("testParamMap".equals(key) || "shellBody".equals(key)) continue;
            paramsMap.put(key.toString(), beanMap.get(key));
        }
        return paramsMap;
    }

    public static <Param extends BaseGroovyShellParam> ShellResult runShell(Param shellparam) {
        ShellResult result = GroovyShellUtil.check(shellparam);
        if (!result.getState().booleanValue()) {
            return result;
        }
        Map<String, Object> paramsMap = GroovyShellUtil.buildParam(shellparam);
        String shellName = shellparam.getShellName();
        try {
            GroovyShell groovyShell = GroovyShellUtil.buildGroovyShell(paramsMap);
            Object o = groovyShell.evaluate(shellparam.getShellBody(), shellName);
            result.setResultData(o);
            groovyShell.getClassLoader().clearCache();
        }
        catch (Exception e) {
            result.setErrMsg("\u811a\u672c[" + shellName + "]\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u4f53\u548c\u811a\u672c\u53c2\u6570");
            result.setThrowable(e);
            result.setState(false);
            log.warn("\u811a\u672c[" + shellName + "]\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u811a\u672c\u4f53\u548c\u811a\u672c\u53c2\u6570 >>> shell={}, shellName={}", new Object[]{shellparam.getShellName(), shellName, e});
        }
        return result;
    }

    private static GroovyShell buildGroovyShell(Map<String, Object> params) {
        GroovyShell groovyShell = new GroovyShell();
        if (null != params) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                groovyShell.setVariable(entry.getKey(), entry.getValue());
            }
        }
        return groovyShell;
    }

    private static ShellResult check(BaseGroovyShellParam param) {
        ShellResult result = new ShellResult();
        String shellName = param.getShellName();
        if (StringUtils.isEmpty((Object)param.getShellBody()) || StringUtils.isEmpty((Object)shellName)) {
            result.setErrMsg("\u5df2\u4e2d\u65ad\u811a\u672c\u6267\u884c\uff0c\u8bf7\u6307\u5b9a\u811a\u672c\u4f53\u6216\u811a\u672c\u7f16\u7801");
            result.setState(false);
            log.warn("\u5df2\u4e2d\u65ad\u811a\u672c\u6267\u884c\uff0c\u8bf7\u6307\u5b9a\u811a\u672c\u4f53\u6216\u811a\u672c\u7f16\u7801 >>> shell={}, shellName={}", (Object)param.getShellBody(), (Object)shellName);
            return result;
        }
        return result;
    }
}

