/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.core;

import com.biz.crm.annotation.Klock;
import com.biz.crm.config.KlockConfig;
import com.biz.crm.core.BusinessKeyProvider;
import com.biz.crm.model.LockInfo;
import com.biz.crm.model.LockType;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LockInfoProvider {
    private static final String LOCK_NAME_PREFIX = "lock";
    private static final String LOCK_NAME_SEPARATOR = ".";
    @Autowired
    private KlockConfig klockConfig;
    @Autowired
    private BusinessKeyProvider businessKeyProvider;
    private static final Logger logger = LoggerFactory.getLogger(LockInfoProvider.class);

    LockInfo get(JoinPoint joinPoint, Klock klock) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        LockType type = klock.lockType();
        String businessKeyName = this.businessKeyProvider.getKeyName(joinPoint, klock);
        String lockName = "lock." + this.getName(klock.name(), signature) + businessKeyName;
        long waitTime = this.getWaitTime(klock);
        long leaseTime = this.getLeaseTime(klock);
        if (leaseTime == -1L && logger.isWarnEnabled()) {
            logger.warn("Trying to acquire Lock({}) with no expiration, Klock will keep prolong the lock expiration while the lock is still holding by current thread. This may cause dead lock in some circumstances.", (Object)lockName);
        }
        return new LockInfo(type, lockName, waitTime, leaseTime);
    }

    private String getName(String annotationName, MethodSignature signature) {
        if (annotationName.isEmpty()) {
            return String.format("%s.%s", signature.getDeclaringTypeName(), signature.getMethod().getName());
        }
        return annotationName;
    }

    private long getWaitTime(Klock lock) {
        return lock.waitTime() == Long.MIN_VALUE ? this.klockConfig.getWaitTime() : lock.waitTime();
    }

    private long getLeaseTime(Klock lock) {
        return lock.leaseTime() == Long.MIN_VALUE ? this.klockConfig.getLeaseTime() : lock.leaseTime();
    }
}

