/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedissonUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedissonClient redissonClient;

    public RLock createLock(String key) {
        RLock lock = this.redissonClient.getLock(key);
        return lock;
    }

    public boolean tryLock(RLock rLock, long waitTime, long lockTime) {
        boolean reBoolean = false;
        try {
            reBoolean = rLock.tryLock(waitTime, lockTime, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.error("\u52a0\u9501\u5931\u8d25\uff0c\u9501\uff1a{}", (Object)rLock.getName(), (Object)e);
        }
        return reBoolean;
    }

    public void unLock(RLock rLock) {
        if (null == rLock) {
            return;
        }
        try {
            rLock.unlock();
        }
        catch (Exception e) {
            String name = rLock.getName();
            this.logger.error("\u91ca\u653e\u9501\u5931\u8d25\uff0c\u9501\uff1a{}", (Object)(StringUtils.isEmpty((Object)name) ? "" : name), (Object)e);
        }
    }
}

