/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.lock;

import com.biz.crm.lock.FairLock;
import com.biz.crm.lock.Lock;
import com.biz.crm.lock.ReadLock;
import com.biz.crm.lock.ReentrantLock;
import com.biz.crm.lock.WriteLock;
import com.biz.crm.model.LockInfo;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class LockFactory {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedissonClient redissonClient;

    public Lock getLock(LockInfo lockInfo) {
        switch (lockInfo.getType()) {
            case Reentrant: {
                return new ReentrantLock(this.redissonClient, lockInfo);
            }
            case Fair: {
                return new FairLock(this.redissonClient, lockInfo);
            }
            case Read: {
                return new ReadLock(this.redissonClient, lockInfo);
            }
            case Write: {
                return new WriteLock(this.redissonClient, lockInfo);
            }
        }
        return new ReentrantLock(this.redissonClient, lockInfo);
    }
}

