/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.lock;

import com.biz.crm.lock.Lock;
import com.biz.crm.model.LockInfo;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RedissonClient;

public class WriteLock
implements Lock {
    private RReadWriteLock rLock;
    private final LockInfo lockInfo;
    private RedissonClient redissonClient;

    public WriteLock(RedissonClient redissonClient, LockInfo info) {
        this.redissonClient = redissonClient;
        this.lockInfo = info;
    }

    @Override
    public boolean acquire() {
        try {
            this.rLock = this.redissonClient.getReadWriteLock(this.lockInfo.getName());
            return this.rLock.writeLock().tryLock(this.lockInfo.getWaitTime(), this.lockInfo.getLeaseTime(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean release() {
        if (this.rLock.writeLock().isHeldByCurrentThread()) {
            try {
                return (Boolean)this.rLock.writeLock().forceUnlockAsync().get();
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return false;
    }
}

