/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.core;

import com.biz.crm.annotation.Klock;
import com.biz.crm.core.LockInfoProvider;
import com.biz.crm.handler.KlockInvocationException;
import com.biz.crm.lock.Lock;
import com.biz.crm.lock.LockFactory;
import com.biz.crm.model.LockInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Aspect
@Component
@Order(value=0)
public class KlockAspectHandler {
    private static final Logger logger = LoggerFactory.getLogger(KlockAspectHandler.class);
    @Autowired
    LockFactory lockFactory;
    @Autowired
    private LockInfoProvider lockInfoProvider;
    private final Map<String, LockRes> currentThreadLock = new ConcurrentHashMap<String, LockRes>();

    @Around(value="@annotation(klock)")
    public Object around(ProceedingJoinPoint joinPoint, Klock klock) throws Throwable {
        LockInfo lockInfo = this.lockInfoProvider.get((JoinPoint)joinPoint, klock);
        String curentLock = this.getCurrentLockId((JoinPoint)joinPoint, klock);
        this.currentThreadLock.put(curentLock, new LockRes(lockInfo, false));
        Lock lock = this.lockFactory.getLock(lockInfo);
        boolean lockRes = lock.acquire();
        if (!lockRes) {
            if (logger.isWarnEnabled()) {
                logger.warn("Timeout while acquiring Lock({})", (Object)lockInfo.getName());
            }
            if (!StringUtils.isEmpty((Object)klock.customLockTimeoutStrategy())) {
                return this.handleCustomLockTimeout(klock.customLockTimeoutStrategy(), (JoinPoint)joinPoint);
            }
            klock.lockTimeoutStrategy().handle(lockInfo, lock, (JoinPoint)joinPoint);
        }
        this.currentThreadLock.get(curentLock).setLock(lock);
        this.currentThreadLock.get(curentLock).setRes(true);
        return joinPoint.proceed();
    }

    @AfterReturning(value="@annotation(klock)")
    public void afterReturning(JoinPoint joinPoint, Klock klock) throws Throwable {
        String curentLock = this.getCurrentLockId(joinPoint, klock);
        this.releaseLock(klock, joinPoint, curentLock);
        this.cleanUpThreadLocal(curentLock);
    }

    @AfterThrowing(value="@annotation(klock)", throwing="ex")
    public void afterThrowing(JoinPoint joinPoint, Klock klock, Throwable ex) throws Throwable {
        String curentLock = this.getCurrentLockId(joinPoint, klock);
        this.releaseLock(klock, joinPoint, curentLock);
        this.cleanUpThreadLocal(curentLock);
        throw ex;
    }

    private Object handleCustomLockTimeout(String lockTimeoutHandler, JoinPoint joinPoint) throws Throwable {
        Method currentMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object target = joinPoint.getTarget();
        Method handleMethod = null;
        try {
            handleMethod = joinPoint.getTarget().getClass().getDeclaredMethod(lockTimeoutHandler, currentMethod.getParameterTypes());
            handleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal annotation param customLockTimeoutStrategy", e);
        }
        Object[] args = joinPoint.getArgs();
        Object res = null;
        try {
            res = handleMethod.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new KlockInvocationException("Fail to invoke custom lock timeout handler: " + lockTimeoutHandler, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return res;
    }

    private void releaseLock(Klock klock, JoinPoint joinPoint, String curentLock) throws Throwable {
        LockRes lockRes = this.currentThreadLock.get(curentLock);
        if (lockRes.getRes().booleanValue()) {
            boolean releaseRes = this.currentThreadLock.get(curentLock).getLock().release();
            lockRes.setRes(false);
            if (!releaseRes) {
                this.handleReleaseTimeout(klock, lockRes.getLockInfo(), joinPoint);
            }
        }
    }

    private void cleanUpThreadLocal(String curentLock) {
        this.currentThreadLock.remove(curentLock);
    }

    private String getCurrentLockId(JoinPoint joinPoint, Klock klock) {
        LockInfo lockInfo = this.lockInfoProvider.get(joinPoint, klock);
        String curentLock = Thread.currentThread().getId() + lockInfo.getName();
        return curentLock;
    }

    private void handleReleaseTimeout(Klock klock, LockInfo lockInfo, JoinPoint joinPoint) throws Throwable {
        if (logger.isWarnEnabled()) {
            logger.warn("Timeout while release Lock({})", (Object)lockInfo.getName());
        }
        if (!StringUtils.isEmpty((Object)klock.customReleaseTimeoutStrategy())) {
            this.handleCustomReleaseTimeout(klock.customReleaseTimeoutStrategy(), joinPoint);
        } else {
            klock.releaseTimeoutStrategy().handle(lockInfo);
        }
    }

    private void handleCustomReleaseTimeout(String releaseTimeoutHandler, JoinPoint joinPoint) throws Throwable {
        Method currentMethod = ((MethodSignature)joinPoint.getSignature()).getMethod();
        Object target = joinPoint.getTarget();
        Method handleMethod = null;
        try {
            handleMethod = joinPoint.getTarget().getClass().getDeclaredMethod(releaseTimeoutHandler, currentMethod.getParameterTypes());
            handleMethod.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Illegal annotation param customReleaseTimeoutStrategy", e);
        }
        Object[] args = joinPoint.getArgs();
        try {
            handleMethod.invoke(target, args);
        }
        catch (IllegalAccessException e) {
            throw new KlockInvocationException("Fail to invoke custom release timeout handler: " + releaseTimeoutHandler, e);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private class LockRes {
        private LockInfo lockInfo;
        private Lock lock;
        private Boolean res;

        LockRes(LockInfo lockInfo, Boolean res) {
            this.lockInfo = lockInfo;
            this.res = res;
        }

        LockInfo getLockInfo() {
            return this.lockInfo;
        }

        public Lock getLock() {
            return this.lock;
        }

        public void setLock(Lock lock) {
            this.lock = lock;
        }

        Boolean getRes() {
            return this.res;
        }

        void setRes(Boolean res) {
            this.res = res;
        }

        void setLockInfo(LockInfo lockInfo) {
            this.lockInfo = lockInfo;
        }
    }
}

