/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.lock;

import com.biz.crm.lock.Lock;
import com.biz.crm.model.LockInfo;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public class ReentrantLock
implements Lock {
    private RLock rLock;
    private final LockInfo lockInfo;
    private RedissonClient redissonClient;

    public ReentrantLock(RedissonClient redissonClient, LockInfo lockInfo) {
        this.redissonClient = redissonClient;
        this.lockInfo = lockInfo;
    }

    @Override
    public boolean acquire() {
        try {
            this.rLock = this.redissonClient.getLock(this.lockInfo.getName());
            return this.rLock.tryLock(this.lockInfo.getWaitTime(), this.lockInfo.getLeaseTime(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean release() {
        if (this.rLock.isHeldByCurrentThread()) {
            try {
                return (Boolean)this.rLock.forceUnlockAsync().get();
            }
            catch (InterruptedException e) {
                return false;
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        return false;
    }

    public String getKey() {
        return this.lockInfo.getName();
    }
}

