/*
 * Decompiled with CFR 0.152.
 */
package cn.com.bizunited.wine.base.localhost.spring;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;

public class LocalhostPropertySource
extends PropertySource<Void> {
    private static final Logger log = LoggerFactory.getLogger(LocalhostPropertySource.class);
    private static final String SOURCE_NAME = "primus.localhost";
    private static final String PREFIX = "primus.localhost.";

    public LocalhostPropertySource(String name) {
        super(name);
    }

    public LocalhostPropertySource() {
        this(SOURCE_NAME);
    }

    public Object getProperty(String name) {
        if (name.startsWith(PREFIX)) {
            try {
                return this.getPropertyWithKey(name.substring(PREFIX.length()));
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u672c\u5730\u4e3b\u673a\u552f\u4e00\u5c5e\u6027\u51fa\u9519,\u8fd4\u56de\u9ed8\u8ba4\u503c", (Throwable)e);
                return "localhost";
            }
        }
        return null;
    }

    private String getPropertyWithKey(String key) throws Exception {
        switch (key) {
            case "mac": {
                return this.getLocalhostMacAddress();
            }
            case "ip": {
                return this.getLocalhostIpAddress();
            }
        }
        throw new IllegalArgumentException("\u65e0\u6548\u7684\u5c5e\u6027key:primus.localhost." + key);
    }

    private String getLocalhostIpAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    private String getLocalhostMacAddress() throws Exception {
        InetAddress host = InetAddress.getLocalHost();
        byte[] hardwareAddress = NetworkInterface.getByInetAddress(host).getHardwareAddress();
        return Hex.encodeHexString((byte[])hardwareAddress);
    }
}

