/**
 * 
 */
package com.biz.cascore.shiro;

import org.apache.shiro.web.tags.PermissionTag;

/**
 * 自定义 权限标签 是否拥有 指定权限中的任意一种
 * 
 * @Description:
 * @ClassName: com.eshop.system.shiro.HasAnyPermission
 * @author: Omar(zp)
 * @date: 2015年4月29日 下午12:01:39
 * 
 */
public class HasAnyPermission extends PermissionTag {

	/**
	 * @Fields serialVersionUID : TODO
	 */
	private static final long serialVersionUID = 1L;

	private static final String PERMISSION_NAMES_DELIMETER = ";";

	/**
	 * @Description:
	 */
	public HasAnyPermission() {
	}

	/**
	 * 是否拥有自定的权限
	 */
	@Override
	protected boolean showTagBody(String permissionNames) {
		boolean hasAnyPermission = false;
		for (String permission : permissionNames.split(PERMISSION_NAMES_DELIMETER)) {
			if (isPermitted(permission)) {
				hasAnyPermission = true;
				break;
			}
		}
		return hasAnyPermission;
	}
}
