package com.biz.cascore.shiro;

import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.permission.WildcardPermissionResolver;

import com.biz.cascore.utils.WebApplicationContextUtils;

public class MyWildcardPermissionResolver extends WildcardPermissionResolver{
	
	 protected String appName;
	 
	@Override
	public Permission resolvePermission(String permissionString) {
		appName = WebApplicationContextUtils.getInstance().getCurrentAppName();
		String header = appName+"-";
		if(!permissionString.startsWith(header)){
			permissionString = header+permissionString;
		}
		return new MyWildcardPermission(permissionString);
	}

}
