/**
 * @Description: 
 * @ClassName: com.biz.omsadmin.util.AdminLTEParseUtils
 * @author: Omar(OmarZhang)
 * @date: 2016年5月6日 下午12:32:56 
 */
package com.biz.cascore.utils;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

import com.biz.cascore.pagination.CommonSearch;
import com.biz.cascore.pagination.CommonSort;

/**
 * @Description: 
 * @ClassName: com.biz.omsadmin.util.AdminLTEParseUtils
 * @author: Omar(OmarZhang)
 * @date: 2016年5月6日 下午12:32:56 
 *
 */
public class AdminLTEParseUtils {
	/**
	 * 通过http获取排序信息
	 * @Title: getByRequest 
	 * @param request
	 * @param definedColumnMap 自定义的排序 传入的列名称与数据库的名称对应 
	 * 注: Map ==> key: 页面的列名称  value: 数据库中的列名称
	 * 如果页面的列名称与数据库的列名称相同 可以对该字段不用映射
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月6日 下午12:34:47
	 */
	public static CommonSort getSortByRequest(HttpServletRequest request,Map<String,String> definedColumnMap) {
		Integer columnIndex = Integer.parseInt(request.getParameter("order[0][column]"));
		String columnName = request.getParameter("columns["+columnIndex+"][data]");
		String sort = request.getParameter("order[0][dir]");
		String sortName = columnName;
		if(definedColumnMap != null && !definedColumnMap.isEmpty()) {
			sortName = definedColumnMap.get(columnName);
			if(StringUtils.isBlank(sortName)) {
				sortName = columnName;
			}
		}
		return  new CommonSort(sortName,sort);
	}
	
	/**
	 * 通过http 获取搜索信息
	 * @Title: getSearchByRequest 
	 * @param request
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月6日 下午12:39:15
	 */
	public static CommonSearch getSearchByRequest(HttpServletRequest request){
		String searchVal = request.getParameter("search[value]");
		searchVal = StringUtils.trim(searchVal);
		searchVal = toChinese(searchVal);
		Boolean regex = BooleanUtils.toBoolean(request.getParameter("search[regex]"));
		return new CommonSearch(searchVal,regex);
	}
	
	private static boolean isChinese(char c) {
		Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
		if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS
				|| ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
				|| ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A
				|| ub == Character.UnicodeBlock.GENERAL_PUNCTUATION
				|| ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION
				|| ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS) {
			return true;
		}
		return false;
	}
	
	private static boolean isMessyCode(String strName) {
		Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
		Matcher m = p.matcher(strName);
		String after = m.replaceAll("");
		String temp = after.replaceAll("\\p{P}", "");
		char[] ch = temp.trim().toCharArray();
		float chLength = 0 ;
		float count = 0;
		for (int i = 0; i < ch.length; i++) {
			char c = ch[i];
			if (!Character.isLetterOrDigit(c)) {
				if (!isChinese(c)) {
					count = count + 1;
				}
				chLength++; 
			}
		}
		float result = count / chLength ;
		if (result > 0.4) {
			return true;
		} else {
			return false;
		}
	}
	
	private static String toChinese(String msg){
		if(isMessyCode(msg)){
			try {
				return new String(msg.getBytes("ISO8859-1"), "UTF-8");
			} catch (Exception e) {
			}
		}
		return msg ; 
	}
	
	/**
	 * 将编码转换为UTF-8
	 * @Title: getSearchByRequest 
	 * @param toParseStr 被转换的字符串
	 * @return
	 * @author: Omar(OmarZhang)
	 * @date: 2016年5月6日 下午12:39:15
	 */
	public static String parseToUTF8(String toParseStr){
		if(StringUtils.isNotBlank(toParseStr)) {
			return toChinese(toParseStr);
		}
		return toParseStr;
	}
	
}
