package com.biz.cascore.utils;

import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

import javax.servlet.ServletContext;

/**
 * 获取WebApplicationContext
 * @Description: 
 * @ClassName: com.eshop.core.util.WebApplicationContextUtils
 * @author: Omar(zp)
 * @date: 2015年5月4日 下午2:50:48 
 *
 */
public class WebApplicationContextUtils {
	
	private final static String DEFAULT_APP_NAME="applicationName";
	
	private static WebApplicationContext webApplicationContext;
	
	private static WebApplicationContextUtils webApplicationContextUtils;
	
	private WebApplicationContextUtils(){
		webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
	}
	
	public static  WebApplicationContextUtils getInstance(){
		synchronized (WebApplicationContextUtils.class) {
			if(webApplicationContextUtils ==  null) {
				webApplicationContextUtils = new WebApplicationContextUtils();
			}
		}
		return webApplicationContextUtils;
	}
	
	/**
	 * 获取ServletContext
	 * @Title: getServletContext 
	 * @return
	 */
	public ServletContext getServletContext(){
		if(webApplicationContext == null) {
			return null;
		}
		return webApplicationContext.getServletContext();
	}
	
	/**
	 * 获取对象
	 * @Title: get 
	 * @param id
	 * @param clazz
	 * @author: Omar(OmarZhang)
	 * @date: 2016年6月8日 下午12:45:16
	 */
	public <T> T get(String id,Class<T> clazz) {
		return webApplicationContext.getBean(id, clazz);
	}
	
	/**
	 * 获取web.xml 中的值
	 * @Title: getInitParameter 
	 * @param key
	 * @return
	 */
	public String getInitParameter(String key) {
		if(getServletContext() != null) {
			return getServletContext().getInitParameter(key);
		}
		return null;
	}
	
	/**
	 * 获取当前web.xml中的 applicationName
	 * @Title: getCurrentAppName 
	 * @return
	 */
	public String getCurrentAppName() {
		return getInitParameter(DEFAULT_APP_NAME);
	}

}
