/*
 * Decompiled with CFR 0.152.
 */
package com.biz.cascore.pagination;

import com.biz.cascore.pagination.CommonSearch;
import com.biz.cascore.pagination.CommonSort;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Pageable
implements Serializable {
    private static final long serialVersionUID = -6102605810901056372L;
    private static final int DEFAULT_PAGE_NUMBER = 1;
    private static final int DEFAULT_PAGE_SIZE = 5;
    private static final int MAX_PAGE_SIZE = 100;
    private int page = 1;
    private int rows = 5;
    private CommonSearch searchCondition;
    private CommonSort sortCondition;
    private Map<String, Object> queryCondition = new HashMap<String, Object>();

    public Pageable() {
    }

    public Pageable(Integer page, Integer rows) {
        if (page != null && page >= 1) {
            this.page = page / rows + 1;
        }
        if (rows != null && rows >= 1 && rows <= 100) {
            this.rows = rows;
        }
    }

    public Pageable(Integer page, Integer rows, CommonSearch commonSearch, CommonSort commonSort) {
        if (page != null && page >= 1) {
            this.page = page / rows + 1;
        }
        if (rows != null && rows >= 1 && rows <= 100) {
            this.rows = rows;
        }
        this.searchCondition = commonSearch;
        this.sortCondition = commonSort;
    }

    public void setPage(int page) {
        if (page < 1) {
            page = 1;
        }
        this.page = page;
    }

    public void setRows(int rows) {
        if (rows < 1 || rows > 100) {
            rows = 5;
        }
        this.rows = rows;
    }

    public Map<String, Object> getQueryCondition() {
        return this.queryCondition;
    }

    public void setQueryCondition(Map<String, Object> queryCondition) {
        this.queryCondition = queryCondition;
    }

    public int getPage() {
        return this.page;
    }

    public int getRows() {
        return this.rows;
    }

    public CommonSearch getSearchCondition() {
        return this.searchCondition;
    }

    public void setSearchCondition(CommonSearch searchCondition) {
        this.searchCondition = searchCondition;
    }

    public CommonSort getSortCondition() {
        return this.sortCondition;
    }

    public void setSortCondition(CommonSort sortCondition) {
        this.sortCondition = sortCondition;
    }
}

