/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.generator.utils;

import com.biz.crm.generator.model.ColumnEntity;
import com.biz.crm.generator.model.TableEntity;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenUtils {
    private static final Logger log = LoggerFactory.getLogger(GenUtils.class);
    private static final String FILE_NAME_MODEL = "Model.java.vm";
    private static final String FILE_NAME_MAPPER = "Mapper.java.vm";
    private static final String FILE_NAME_MAPPERXML = "Mapper.xml.vm";
    private static final String FILE_NAME_SERVICE = "Service.java.vm";
    private static final String FILE_NAME_SERVICEIMPL = "ServiceImpl.java.vm";
    private static final String FILE_NAME_CONTROLLER = "Controller.java.vm";
    private static final String FILE_NAME_PAGE = "index.html.vm";
    private static final String TEMPLATE_PATH = "template/";
    private static final String PACKAGE = "package";
    private static final String MODULE_NAME = "moduleName";
    private static final String FILE_NAME_DTO = "DTO.java.vm";
    private static final String FILE_NAME_RESP_VO = "RespVo.java.vm";
    private static final String FILE_FEIGN = "Feign.java.vm";
    private static final String FILE_FEIGN_IMPL = "FeignImpl.java.vm";
    private static final String FILE_NEBULA_SERVICE = "Nebula.java.vm";
    private static final String FILE_NEBULA_SERVICE_IMPL = "NebulaImpl.java.vm";

    private GenUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> getTemplates() {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add("template/Model.java.vm");
        templates.add("template/Mapper.java.vm");
        templates.add("template/Mapper.xml.vm");
        templates.add("template/Service.java.vm");
        templates.add("template/ServiceImpl.java.vm");
        templates.add("template/Controller.java.vm");
        templates.add("template/DTO.java.vm");
        templates.add("template/RespVo.java.vm");
        templates.add("template/Feign.java.vm");
        templates.add("template/FeignImpl.java.vm");
        templates.add("template/Nebula.java.vm");
        templates.add("template/NebulaImpl.java.vm");
        return templates;
    }

    public static void generatorCode(Map<String, String> table, List<Map<String, Object>> columns, ZipOutputStream zip, String functionPackageName, String applicationName) {
        Configuration config = GenUtils.getConfig();
        boolean hasBigDecimal = false;
        TableEntity tableEntity = new TableEntity();
        tableEntity.setTableName(table.get("tableName"));
        tableEntity.setComments(table.get("tableComment"));
        String className = GenUtils.tableToJava(tableEntity.getTableName(), config.getString("tablePrefix"));
        tableEntity.setClassName(className);
        tableEntity.setClassname(StringUtils.uncapitalize((String)className));
        tableEntity.setVelocityCount(columns.size() - 1);
        ArrayList<ColumnEntity> columsList = new ArrayList<ColumnEntity>();
        for (Map<String, Object> column : columns) {
            ColumnEntity columnEntity = new ColumnEntity();
            columnEntity.setColumnName(column.get("columnName").toString());
            columnEntity.setDataType(column.get("dataType").toString());
            columnEntity.setComments(column.get("columnComment").toString());
            columnEntity.setExtra(column.get("extra").toString());
            columnEntity.setCharacterMaximumLength((BigInteger)column.get("characterMaximumLength"));
            columnEntity.setNumericPrecision((BigInteger)column.get("numericPrecision"));
            columnEntity.setNumericScale((BigInteger)column.get("numericScale"));
            String attrName = GenUtils.columnToJava(columnEntity.getColumnName());
            columnEntity.setAttrName(attrName);
            columnEntity.setAttrname(StringUtils.uncapitalize((String)attrName));
            String attrType = config.getString(columnEntity.getDataType(), "unknowType");
            columnEntity.setAttrType(attrType);
            if (!hasBigDecimal && "BigDecimal".equals(attrType)) {
                hasBigDecimal = true;
            }
            if ("PRI".equalsIgnoreCase(column.get("columnKey").toString()) && tableEntity.getPk() == null) {
                tableEntity.setPk(columnEntity);
            }
            columsList.add(columnEntity);
        }
        tableEntity.setColumns(columsList);
        if (tableEntity.getPk() == null) {
            tableEntity.setPk(tableEntity.getColumns().get(0));
        }
        Properties prop = new Properties();
        prop.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        Velocity.init((Properties)prop);
        String mainPath = config.getString("mainPath");
        mainPath = StringUtils.isBlank((String)mainPath) ? "io.renren" : mainPath;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationName", applicationName);
        map.put("tableName", tableEntity.getTableName());
        map.put("comments", tableEntity.getComments());
        map.put("pk", tableEntity.getPk());
        map.put("className", tableEntity.getClassName());
        map.put("classname", tableEntity.getClassname());
        map.put("pathName", tableEntity.getClassname().toLowerCase());
        map.put("columns", tableEntity.getColumns());
        map.put("hasBigDecimal", hasBigDecimal);
        map.put("mainPath", mainPath);
        map.put(PACKAGE, config.getString(PACKAGE));
        map.put(MODULE_NAME, config.getString(MODULE_NAME));
        map.put("author", config.getString("author"));
        map.put("email", config.getString("email"));
        map.put("functionPackageName", functionPackageName);
        map.put("datetime", GenUtils.dateSimp(new Date(), "yyyy-MM-dd HH:mm:ss"));
        VelocityContext context = new VelocityContext(map);
        List<String> templates = GenUtils.getTemplates();
        for (String template : templates) {
            try {
                StringWriter sw = new StringWriter();
                Throwable throwable = null;
                try {
                    Template tpl = Velocity.getTemplate((String)template, (String)"UTF-8");
                    tpl.merge((Context)context, (Writer)sw);
                    zip.putNextEntry(new ZipEntry(GenUtils.getFileName(template, tableEntity.getClassName(), config.getString(PACKAGE), config.getString(MODULE_NAME))));
                    IOUtils.write((String)sw.toString(), (OutputStream)zip, (Charset)StandardCharsets.UTF_8);
                    zip.closeEntry();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sw == null) continue;
                    if (throwable != null) {
                        try {
                            sw.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sw.close();
                }
            }
            catch (IOException e) {
                log.error("generatorCode-error", (Throwable)e);
            }
        }
    }

    public static String dateSimp(Date obj, String simp) {
        StringBuffer date = new StringBuffer();
        try {
            if (obj != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(simp);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+8:00"));
                date.append(simpleDateFormat.format(obj));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date.toString();
    }

    public static String columnToJava(String columnName) {
        return WordUtils.capitalizeFully((String)columnName, (char[])new char[]{'_'}).replace("_", "");
    }

    public static String tableToJava(String tableName, String tablePrefix) {
        if (StringUtils.isNotBlank((String)tablePrefix)) {
            tableName = tableName.substring(tablePrefix.length());
        }
        return GenUtils.columnToJava(tableName);
    }

    public static Configuration getConfig() {
        try {
            return new PropertiesConfiguration("generator.properties");
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff0c", e);
        }
    }

    public static String getFileName(String template, String className, String packageName, String moduleName) {
        String packagePath = "main" + File.separator + "java" + File.separator;
        if (StringUtils.isNotBlank((String)packageName)) {
            packagePath = packagePath + packageName.replace(".", File.separator) + File.separator + moduleName + File.separator;
        }
        if (template.contains(FILE_NAME_MODEL)) {
            return packagePath + "model" + File.separator + className + "Entity.java";
        }
        if (template.contains(FILE_NAME_MAPPER)) {
            return packagePath + "mapper" + File.separator + className + "Mapper.java";
        }
        if (template.contains(FILE_NAME_SERVICE)) {
            return packagePath + "service" + File.separator + "I" + className + "Service.java";
        }
        if (template.contains(FILE_NAME_SERVICEIMPL)) {
            return packagePath + "service" + File.separator + "impl" + File.separator + className + "ServiceImpl.java";
        }
        if (template.contains(FILE_NAME_CONTROLLER)) {
            return packagePath + "controller" + File.separator + className + "Controller.java";
        }
        if (template.contains(FILE_NAME_DTO)) {
            return packagePath + "vo" + File.separator + className + "ReqVo.java";
        }
        if (template.contains(FILE_NAME_RESP_VO)) {
            return packagePath + "vo" + File.separator + className + "RespVo.java";
        }
        if (template.contains(FILE_NAME_MAPPERXML)) {
            return "main" + File.separator + "resources" + File.separator + "mapper" + File.separator + className + "Mapper.xml";
        }
        if (template.contains(FILE_NAME_PAGE)) {
            return "main" + File.separator + "view" + File.separator + "pages" + File.separator + moduleName + File.separator + "index.html";
        }
        if (template.contains(FILE_FEIGN)) {
            return packagePath + "feign" + File.separator + className + "Feign.java";
        }
        if (template.contains(FILE_FEIGN_IMPL)) {
            return packagePath + "feign" + File.separator + "impl" + File.separator + className + "FeignImpl.java";
        }
        if (template.contains(FILE_NEBULA_SERVICE)) {
            return packagePath + "nebula" + File.separator + className + "NebulaService.java";
        }
        if (template.contains(FILE_NEBULA_SERVICE_IMPL)) {
            return packagePath + "nebula" + File.separator + "impl" + File.separator + className + "NebulaServiceImpl.java";
        }
        return null;
    }
}

