package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.TaProcessBizRelationService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryReqVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryRespVo;
import com.biz.crm.util.*;
import com.biz.crm.vo.SubmitActivitiResp;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;

/**
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */
@Slf4j
@RestController
@RequestMapping("taActBaseController")
@Api(tags = "流程实例操作")
public class TaActBaseController {

    @Autowired
    private TaProcessBizRelationService relationService;
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @ApiImplicitParams({
            @ApiImplicitParam(name = "key", value = "业务唯一条件", required = false, paramType = "query")
    })
    @ApiOperation(value = "寻流程---提交流程时下拉选择流程接口")
    @PostMapping("/getSubmitActiviti")
    public Result<SubmitActivitiResp> getSubmitActiviti(@RequestParam(value = "key", required = false) String key) {
        SubmitActivitiResp resp = relationService.findProcessByCurrentUserAndMenu();
        return Result.ok(resp);
    }

    @ApiOperation(value = "分页查询流程实例列表")
    @PostMapping("/processInstancePage")
    @CrmLog
    public Result<PageResult<ProcessInstanceQueryRespVo>> processInstancePage(@RequestBody ProcessInstanceQueryReqVo reqVo) {
        PageResult<ProcessInstanceQueryRespVo> result=activitiBusinessService.processInstancePage(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "分页查询已办列表")
    @PostMapping("/taskDonePage")
    @CrmLog
    public Result<PageResult<ProcessInstanceQueryRespVo>> taskDonePage(@RequestBody ProcessInstanceQueryReqVo reqVo) {
        PageResult<ProcessInstanceQueryRespVo> result=activitiBusinessService.taskDonePage(reqVo);
        return Result.ok(result);
    }
}
