package com.biz.crm.activiti.controller;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.activiti.service.ITaNodeConfigService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 流程节点controller
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
@RestController
@RequestMapping("/taNodeConfigController")
@Api(tags = "流程节点配置")
public class TaNodeConfigController {
    @Autowired
    private ITaNodeConfigService taNodeConfigService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TaNodeConfigRespVo>> list(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo) {
        PageResult<TaNodeConfigRespVo> result = taNodeConfigService.findList(taNodeConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 列表
     */
    @ApiOperation(value = "根据processKey或者版本号获取版本节点列表(如果传processKey就默认取最新的版本下的节点)")
    @PostMapping("/queryByProcessKey")
    @CrmLog
    public Result<PageResult<TaNodeConfigRespVo>> queryByProcessKey(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo) {
        PageResult<TaNodeConfigRespVo> result = taNodeConfigService.queryByProcessKey(taNodeConfigReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TaNodeConfigRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TaNodeConfigRespVo respVo = taNodeConfigService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo) {
        taNodeConfigService.save(taNodeConfigReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TaNodeConfigReqVo taNodeConfigReqVo) {
        taNodeConfigService.update(taNodeConfigReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        taNodeConfigService.deleteBatch(ids);
        return Result.ok("删除成功");
    }
    /**
     * 根据流程key获取流程的所有版本
     * @return
     */
    @PostMapping("/getAllProcessVersionKey")
    @ApiOperation("根据流程key获取流程的所有版本")
    public Result<List<TaNodeConfigRespVo>> getAllProcessVersionKey(@RequestBody TaListenerProcReqVo taListenerProcReqVo) {
        List<TaNodeConfigRespVo> taNodeConfigRespVos = taNodeConfigService.getAllProcessVersionKey(taListenerProcReqVo.getProcessKey());
        return Result.ok(taNodeConfigRespVos);
    }
}
