package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.TaProcessBizRelationService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.util.Result;
import com.biz.crm.vo.TaProcessBizRelationReqVo;
import com.biz.crm.vo.TaProcessBizRelationRespVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 这是流程绘制-业务关系相关 Controller
 *
 * @author YuanZiJian
 * @date 2020/12/15 18:01
 * @version: V1.0
 */
@Slf4j
@RestController
@RequestMapping("taProcessBizRelationController")
@Api(tags = " 这是流程绘制-业务关系相关操作")
public class TaProcessBizRelationController {
    @Autowired
    private TaProcessBizRelationService relationService;


    /**
     * 根据流程key查找对应的业务关系
     *
     * @return com.biz.crm.util.Result<com.biz.crm.act.vo.TaProcessBizRelationRespVo>
     * @method getRelationByProcessKey
     * @date: 2020/12/15 18:08
     * @author: YuanZiJian
     */
    @ApiOperation(value = "根据流程key查找对应的业务关系(需要传入参数processKey)")
    @PostMapping("/getRelationByProcessKey")
    @CrmLog
    public Result<TaProcessBizRelationRespVo> getRelationByProcessKey(@RequestBody String processKey) {
        return Result.ok(relationService.getRelationByProcessKey(processKey));
    }

    /**
     * 查出流程列表
     * @method getListRelation
     * @date: 2020/12/19 13:59
     * @author: YuanZiJian
     * @param taProcessBizRelationReqVo
     * @return com.biz.crm.util.Result<java.util.List<com.biz.crm.act.vo.TaProcessBizRelationRespVo>>
     */
    @ApiOperation(value = "查出流程列表")
    @PostMapping("/getListRelation")
    @CrmLog
    public Result<List<TaProcessBizRelationRespVo>> getListRelation(@RequestBody TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        return Result.ok(relationService.getListRelation(taProcessBizRelationReqVo));
    }


    /**
     * 新增业务关系
     *
     * @param taProcessBizRelationReqVo
     * @return com.biz.crm.util.Result
     * @method insertRelation
     * @date: 2020/12/15 18:07
     * @author: YuanZiJian
     */
    @ApiOperation(value = "新增或更新业务关系")
    @PostMapping("/insertRelation")
    @CrmLog
    public Result insertRelation(@RequestBody TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        relationService.insertRelation(taProcessBizRelationReqVo);
        return Result.ok();
    }


    @ApiOperation(value = "删除业务关系")
    @PostMapping("/deleteRelation")
    @CrmLog
    public Result deleteRelation(@RequestBody String processKey) {
        relationService.deleteRelation(processKey);
        return Result.ok("删除成功");
    }
}
