package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActivitiCurrentTaskEntity;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.mapper
 * @Description: TODO
 * @date 2021/4/20 下午1:34
 */
public interface ActivitiCurrentTaskMapper extends BaseMapper<ActivitiCurrentTaskEntity> {
    /**
     * 查询当前待办任务
     * @param page
     * @param positionCode 职位编号
     * @param bpmRoleCodes 职位编号对应流程角色
     * @return
     */
    @SqlPrivilege(orgCode = "abn.create_org_code",posCode = "abn.create_pos_code")
    List<CurrentTaskVo> listByPositionCode(Page page, @Param("positionCode") String positionCode, @Param("bpmRoleCodes") List<String> bpmRoleCodes,@Param("vo") BpmQueryVo bpmQueryVo );

    /**
     * 查询我提交的流程，包含所有岗位
     * @param page
     * @param positionCodes
     * @return
     */
    List<CurrentTaskVo> listMyBpm(Page page, @Param("positionCodes") List<String> positionCodes);

    /**
     * 驳回流程列表
     * @param page
     * @param positionCodes
     * @return
     */
    List<CurrentTaskVo> listMyRejectBpm(Page page, @Param("positionCodes") List<String> positionCodes);

}
