package com.biz.crm.activiti.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 流程节点Mapper
 * 
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
public interface TaNodeConfigMapper extends BaseMapper<TaNodeConfigEntity> {
    /**
     * 列表
     * @param page
     * @param taNodeConfigReqVo
     * @return
     */
    List<TaNodeConfigRespVo> findList(Page<TaNodeConfigRespVo> page, @Param("vo") TaNodeConfigReqVo taNodeConfigReqVo);

    /**
     * 根据流程版本查询节点
     * @param processVersionKey
     * @return
     */
    List<TaNodeConfigEntity> findNodeByProcessVersionKey(String processVersionKey);

    /**
     *
     * @param processVersionKey
     * @param taskDefKey
     * @return
     */
    TaNodeConfigEntity findNodeByTaskVersionKey(@Param("processVersionKey") String processVersionKey,
                                                @Param("taskDefKey") String taskDefKey);

    String getMaxProcessVersionByKey(@Param("processKey")String processKey);

    /**
     * 获取流程的历史版本ProcessVersion
     * @param processKey
     * @return
     */
    List<TaNodeConfigRespVo> getAllProcessVersionByKey(String processKey);
}
