package com.biz.crm.activiti.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessSummaryRspVO;
import com.biz.crm.nebular.activiti.vo.*;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.service
 * @Description: TODO
 * @date 2021/4/20 下午6:46
 */

public interface BizRuntimeService {
    /**
     * 发起流程
     * @param activitiBusinessVo
     * @return
     */
    String startProcess(ActivitiBusinessVo activitiBusinessVo);

    /**
     * 查询指定职位的任务列表
     * @param
     */
    PageResult<CurrentTaskVo> listByPositionCode(BpmQueryVo bpmQueryVo);

    /**
     * 我提交的流程
     * @param bpmQueryVo
     * @return
     */
    PageResult<CurrentTaskVo> listMyBpm(BpmQueryVo bpmQueryVo);

    /**
     * 我被驳回的流程
     * @param bpmQueryVo
     * @return
     */
    PageResult<CurrentTaskVo> listMyRejectBpm(BpmQueryVo bpmQueryVo);


    /**
     * 获取流程中流程图
     * @param processInstanceId
     * @return
     */
     InputStream getProcessInstancePicInfo(String processInstanceId) ;

    /**
     * 完成流程任务
     * @param completeTaskVo
     */
     void completeTasks(CompleteTaskVo completeTaskVo);

    /**
     * 流程撤回
     * @param crmProcessInstanceId
     */
     void recallTasks(String crmProcessInstanceId);

    /**
     * 获取流程摘要信息
     * @param processInstanceId
     * @return
     */
    ProcessSummaryRspVO getProcessSummary(String processInstanceId);

    /**
     * 传阅
     * @param reqVo
     */
    void circulate(ProcessCirculateReqVo reqVo);

    /**
     * 修改抄送任务的阅读状态
     * @param id
     */
    void updateCopyTaskStatus(String id);

    /**
     * 委派/转办
     * @param reqVo
     */
    void delegateProcess(TaActDelegateReqVo reqVo);

    /**
     * 流程驳回时处理其他事项(项目上去实现逻辑)
     * @param processInstanceId
     */
    void rejectTaskDoOtherThings(String processInstanceId);
    /**
     * 流程通过时处理其他事项(项目上去实现逻辑)
     * @param processInstanceId
     */
    void passTaskDoOtherThings(String processInstanceId);

    /**
     * 提交流程时处理其他事项(项目上去实现逻辑)
     * @param processInstanceId
     */
    void startProcessDoOtherThings(String processInstanceId);
}
