package com.biz.crm.activiti.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;

/**
 * 接口
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
public interface ITaActFileService extends IService<TaActFileEntity> {

    /**
     * 列表
     * @param taActFileReqVo
     * @return PageResult<TaActFileRespVo>
     */
    PageResult<TaActFileRespVo> findList(TaActFileReqVo taActFileReqVo);

    /**
     * 查询
     * @param taActFileReqVo
     * @return TaActFileRespVo
     */
    TaActFileRespVo query(TaActFileReqVo taActFileReqVo);

    /**
     * 新增
     * @param taActFileReqVo
     * @return
     */
    void save(TaActFileReqVo taActFileReqVo);

    /**
     * 更新
     * @param taActFileReqVo
     * @return
     */
    void update(TaActFileReqVo taActFileReqVo);

    /**
     * 删除
     * @param taActFileReqVo
     * @return
     */
    void deleteBatch(TaActFileReqVo taActFileReqVo);

    /**
     * 启用
     * @param taActFileReqVo
     * @return
     */
    void enableBatch(TaActFileReqVo taActFileReqVo);

    /**
     * 禁用
     * @param taActFileReqVo
     * @return
     */
    void disableBatch(TaActFileReqVo taActFileReqVo);
}

