package com.biz.crm.activiti.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;

import java.util.List;

/**
 * 接口
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
public interface ITaActTargetService extends IService<TaActTargetEntity> {

    /**
     * 列表
     * @param taActFileReqVo
     * @return PageResult<TaActTargetRespVo>
     */
    PageResult<TaActTargetRespVo> findList(TaActTargetReqVo taActFileReqVo);


    /**
     * 根据流程实例id查询
     * @param processKey 流程实例id
     * @return
     */
    List<TaActTargetRespVo> findByProcessKey(String processKey);

    /**
     * 查询
     * @param id
     * @return TaActTargetRespVo
     */
    TaActTargetRespVo query(String id);

    /**
     * 新增
     * @param taActFileReqVo
     * @return
     */
    void save(TaActTargetReqVo taActFileReqVo);

    /**
     * 更新
     * @param taActFileReqVo
     * @return
     */
    void update(TaActTargetReqVo taActFileReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param taActFileReqVo
     * @return
     */
    void enableBatch(TaActTargetReqVo taActFileReqVo);

    /**
     * 禁用
     * @param taActFileReqVo
     * @return
     */
    void disableBatch(TaActTargetReqVo taActFileReqVo);
}

