package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.activiti.entity.*;
import com.biz.crm.activiti.mapper.*;
import com.biz.crm.activiti.service.ActivityTaskUtil;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BaseServiceHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.eunm.activiti.ProcessInstanceStatusEnum;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.mdm.user.MdmUserFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.vo.ActGeByteArrayVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.nebular.activiti.vo.ProcessInstanceQueryRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.javax.el.ExpressionFactory;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.repository.ProcessDefinitionQuery;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @Project crm
 * @PackageName com.biz.crm.activiti.service.impl
 * @ClassName ActivitiBusinessHelper
 * @Author HuangLong
 * @Date 2021/5/11 14:11
 * @Description 工作流业务处理工具类
 */
@Component
@Slf4j
public class ActivitiBusinessHelper extends BaseServiceHelper {

    @Resource
    private TaTaskCommunicateMapper communicateMapper;
    @Resource
    private TaActFileMapper actFileMapper;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Resource
    private TaActTargetMapper actTargetMapper;
    @Autowired
    private MdmPositionFeign positionFeign;
    @Resource
    private ActReModelMapper modelMapper;
    @Resource
    private ActivitiCurrentTaskMapper currentTaskMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaNodeConfigMapper nodeConfigMapper;
    @Autowired
    private MdmUserFeign userFeign;
    @Autowired
    private RuntimeService runtimeService;


    /**
     * 计算流程实例的处理总耗时
     * @param createDateAll
     * @param endDateString
     * @return
     */
    public String computeProcessTotalHandleTime(String createDateAll,String endDateString){
        if(StringUtils.isNotEmpty(createDateAll)&& StringUtils.isNotEmpty(endDateString)){
            Date date = DateUtil.str2Date(createDateAll, DateUtil.datetimeFormat);
            Date nowDate = DateUtil.str2Date(endDateString, DateUtil.datetimeFormat);
            long time = date.getTime();
            long nowDateTime = nowDate.getTime();
            long l = nowDateTime - time;
            StringBuffer stringBuffer = new StringBuffer();
            long l1 = l / (24 * 60 * 60 * 1000);
            stringBuffer.append(l1).append("天");
            long l2 = l - l1 * (24 * 60 * 60 * 1000);
            long l3 = l2 / (60 * 60 * 1000);
            stringBuffer.append(l3).append("小时");
            long l4 = l2 - l3 * (60*60 * 1000);
            long l5 = l4 / (60 * 1000);
            stringBuffer.append(l5).append("分");
            return stringBuffer.toString();
        }
        return null;
    }

    /**
     * 根据流程实例id查询流程文件
     * @param processInstanceIds
     * @return
     */
    public List<TaActFileRespVo> findActFileByProcessInstanceIds(List<String> processInstanceIds,Integer fileType){
        if(CollectionUtils.isEmpty(processInstanceIds)){
            return Lists.newArrayList();
        }
        List<TaActFileEntity> taActFileEntities = actFileMapper.selectList(Wrappers.lambdaQuery(TaActFileEntity.class).in(TaActFileEntity::getProcessInstId, processInstanceIds).eq(Objects.nonNull(fileType),TaActFileEntity::getFileType,fileType).orderByDesc(TaActFileEntity::getCreateDateAll));
        return CrmBeanUtil.copyList(taActFileEntities, TaActFileRespVo.class);
    }

    /**
     * 根据流程key查询关键指标表头配置数据
     * @param processKey
     * @return
     */
    public List<TaActTargetRespVo> findActTargetConfigByProcessKey(String processKey){
        if(StringUtils.isEmpty(processKey)){
            return Lists.newArrayList();
        }
        List<TaActTargetEntity> entities = actTargetMapper.selectList(Wrappers.lambdaQuery(TaActTargetEntity.class).eq(TaActTargetEntity::getProcessKey, processKey));
        return CrmBeanUtil.copyList(entities, TaActTargetRespVo.class);
    }

    /**
     * 通过流程实例id查询流程实例实体
     * @param processInstanceId
     * @return
     */
    public ActivitiBusinessEntity findActivitiBusinessEntityByInstanceId(String processInstanceId){
        ActivitiBusinessEntity businessEntity = activitiBusinessMapper.selectOne(Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getProcessInstanceId, processInstanceId));
        return businessEntity;
    }
    /**
     * 通过流程编号查询流程实例实体
     * @param crmProcessInstanceId
     * @return
     */
    public ActivitiBusinessEntity findActivitiBusinessEntityByCrmInstanceId(String crmProcessInstanceId){
        ActivitiBusinessEntity businessEntity = activitiBusinessMapper.selectOne(Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, crmProcessInstanceId));
        if(Objects.isNull(businessEntity)){
            throw new BusinessException("流程编码:"+crmProcessInstanceId+",对应的流程实例不存在");
        }
        return businessEntity;
    }
    /**
     * 根据职位编码集合查询职位map
     * @param positionCodes
     * @return
     */
     public Map<String, MdmPositionUserOrgRespVo> findPositionMapByCodes(List<String> positionCodes){
         Map<String,MdmPositionUserOrgRespVo> positionMap = Maps.newHashMap();
         if(CollectionUtils.isNotEmpty(positionCodes)){
             MdmPositionUserOrgReqVo reqVo=new MdmPositionUserOrgReqVo();
             reqVo.setPositionCodeList(positionCodes);
             reqVo.setIncludeEmptyUserPosition(true);
             List<MdmPositionUserOrgRespVo> positionByCodeList=Lists.newArrayList();
             try {
                 Result<List<MdmPositionUserOrgRespVo>> positionUserOrgList = positionFeign.findPositionUserOrgList(reqVo);
                 positionByCodeList=positionUserOrgList.getResult();
             } catch (Exception e) {
                 log.error("调用Mdm获取职位数据异常,e={}",e);
             }
             if(CollectionUtils.isNotEmpty(positionByCodeList)){
                 positionMap = positionByCodeList.stream().collect(Collectors.toMap(MdmPositionUserOrgRespVo::getPositionCode, Function.identity()));
             }
         }
         return positionMap;
     }

    /**
     * 根据流程部署id查询流程xml文件
     * @param deploymentId
     * @return
     */
     public ActGeByteArrayVo findProcessXmlByDeploymentId(String deploymentId){
         ActGeByteArrayVo vo = modelMapper.findProcessXmlByDeploymentId(deploymentId);
         return vo;
     }

    /**
     * 获取当前登录人的所有关联职位
     * @return
     */
     public List<String> getCurrentUserPositionCodes(){
         UserRedis user = UserUtils.getUser();
         MdmUserReqVo reqVo=new MdmUserReqVo();
         reqVo.setUserName(user.getUsername());
         List<MdmPositionRespVo> mdmPositionRespVos = ApiResultUtil.objResult(positionFeign.getUserAllPositionList(reqVo), false);
         if(CollectionUtils.isNotEmpty(mdmPositionRespVos)){
             return mdmPositionRespVos.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
         }
         return Lists.newArrayList();
     }

    /**
     *
     * @param operateType
     * @param positionCode
     * @param isAutoExecute 是否是系统自定执行
     * @return
     */
     public String getProcessOperateLogDesc(String operateType,String positionCode,Boolean isAutoExecute){
         UserRedis user = UserUtils.getUser();
         if(StringUtils.isEmpty(positionCode)){
             positionCode=user.getPoscode();
         }
         StringBuffer buffer = new StringBuffer();
         buffer.append(user.getRealname()).append("[").append(positionCode).append("]");
         if(StringUtils.equals(ActivitiOperateTypeEnum.RECOVER.getCode(),operateType)){
             buffer.append("追回流程");
         }
         if(StringUtils.equals(ActivitiOperateTypeEnum.PASS.getCode(),operateType)){
             if(isAutoExecute){
                 return "系统自动执行:";
             }
             buffer.append("签批流程");
         }
         if(StringUtils.equals(ActivitiOperateTypeEnum.REJECT.getCode(),operateType)){
             buffer.append("驳回流程");
         }
         if(StringUtils.equals(ActivitiOperateTypeEnum.COMMUNICATE.getCode(),operateType)){
             buffer.append("发起沟通");
         }
         if(StringUtils.equals(ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode(),operateType)){
             buffer.append("确认沟通");
         }
         if(StringUtils.equals(ActivitiOperateTypeEnum.DELEGATE.getCode(),operateType)){
             buffer.append("委派任务");
         }
         return buffer.toString();
     }

    /**
     * 根据任务id查询当前任务
     * @param taskId
     * @return
     */
     public Task findCurrentTaskByTaskId(String taskId){
         if(StringUtils.isNotEmpty(taskId)){
             Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
             return task;
         }
         return null;
     }

    /**
     * 根据流程key和节点编码查询当前节点实体
     * @param processVersionKey
     * @param nodeCode
     * @return
     */
     public TaNodeConfigEntity findNodeByProcessVersionKeyAndNodeCode(String processVersionKey,String nodeCode){
         //这里的processVersionKey实际上就是流程定义表ACT_RE_PROCDEF的id
         //根据部署id查询流程定义
         ProcessDefinition processDefinition = repositoryService.createProcessDefinitionQuery().processDefinitionId(processVersionKey).singleResult();
         String nodeId = processDefinition.getKey()+":"+processDefinition.getVersion()+":"+nodeCode;
         TaNodeConfigEntity configEntity = nodeConfigMapper.selectOne(Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessNodeId, nodeId));
         return configEntity;
     }

    /**
     * 根据任务获取当前任务的审批岗位名称和岗位编码
     * @param rspVO
     * @param task
     */
    public void setCurrentTaskPosition(OptRecordRspVO rspVO, Task task) {
        //如果当前任务上的任务职位不为空
        StringBuffer nameBuffer = new StringBuffer();
        StringBuffer codeBuffer = new StringBuffer();
        Set<String> existsPositionCodes=Sets.newHashSet();
        if(StringUtils.isNotEmpty(task.getAssignee())){
//            rspVO.setPositionCode(task.getAssignee());
            existsPositionCodes.add(task.getAssignee());
            MdmPositionRespVo positionByCode = PositionUtil.getPositionByCode(task.getAssignee());
            codeBuffer.append(task.getAssignee()).append(",");
            if(Objects.nonNull(positionByCode)){
                nameBuffer.append(positionByCode.getPositionName()).append(",");
            }
        }
        //候选组
        List<IdentityLink> identityLinks = taskService.getIdentityLinksForTask(task.getId());
        if(CollectionUtils.isNotEmpty(identityLinks)){
            identityLinks.forEach(r->{
                if(StringUtils.isNotEmpty(r.getGroupId())){
                    //流程角色,根据流程角色编码查询职位集合
                    Set<String> positionCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, Lists.newArrayList(r.getGroupId())),false);
                    List<MdmPositionRespVo> positions = PositionUtil.getPositionByCodeList(Lists.newArrayList(positionCodes));
                    codeBuffer.append(r.getGroupId()).append(",");
                    positions.stream().filter(o->!existsPositionCodes.contains(o.getPositionCode())).forEach(o->{
                        existsPositionCodes.add(o.getPositionCode());
                        nameBuffer.append(o.getPositionName()).append(",");
                    });
                }
                if(StringUtils.isNotEmpty(r.getUserId())&&!existsPositionCodes.contains(r.getUserId())){
                    existsPositionCodes.add(r.getUserId());
                    MdmPositionRespVo positionByCode = PositionUtil.getPositionByCode(r.getUserId());
                    codeBuffer.append(r.getUserId()).append(",");
                    if(Objects.nonNull(positionByCode)){
                        nameBuffer.append(positionByCode.getPositionName()).append(",");
                    }
                }
            });
        }
        rspVO.setPositionName(nameBuffer.toString());
        rspVO.setPositionCode(codeBuffer.toString());
        if(CollectionUtils.isNotEmpty(existsPositionCodes)){
            MdmPositionUserOrgReqVo mdmPositionUserOrgReqVo=new MdmPositionUserOrgReqVo();
            mdmPositionUserOrgReqVo.setPositionCodeList(Lists.newArrayList(existsPositionCodes));
            List<MdmPositionUserOrgRespVo> mdmPositionUserOrgRespVos = ApiResultUtil.objResult(positionFeign.findPositionUserOrgList(mdmPositionUserOrgReqVo), false);
            StringBuffer userBuffer=new StringBuffer(" ");
            if(CollectionUtils.isNotEmpty(mdmPositionUserOrgRespVos)){
                mdmPositionUserOrgRespVos.forEach(o->{
                    if(StringUtils.isNotEmpty(o.getUserName())&&StringUtils.isNotEmpty(o.getFullName())){
                        userBuffer.append(o.getUserName()).append("(").append(o.getFullName()).append(")").append(",");
                    }
                });
            }
            rspVO.setCurrentAccounts(userBuffer.toString());
        }

    }

    /**
     * 查询流程当前未处理的节点
     * @param processVersionKey
     * @param taskList
     * @return
     */
    public List<TaNodeConfigEntity> findFutureNodesByProcessVersionKey(String processVersionKey,List<Task> taskList) {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                .getDeployedProcessDefinition(taskList.get(0).getProcessDefinitionId());
        String currentTaskDefKey = taskList.get(0).getTaskDefinitionKey();
        List<String> list = Lists.newArrayList();
        Boolean outFlag=false;
        while (!outFlag) {
            ActivityImpl activityImpl = processDefinition.findActivity(currentTaskDefKey);
            //出线对象
            List<PvmTransition> outTransitions = activityImpl.getOutgoingTransitions();
            if(CollectionUtils.isEmpty(outTransitions)){
                outFlag=true;
            }
            for (PvmTransition tr : outTransitions) {
                PvmActivity ac = tr.getDestination(); // 获取线路的终点节点
                if (Objects.nonNull(ac)) {
                    Object type = ac.getProperty("type");
                    if(Objects.isNull(type)||StringUtils.contains(type.toString().toLowerCase(),"end")){
                        outFlag=true;
                    }else {
                        list.add(ac.getId());
                        currentTaskDefKey = ac.getId();
                    }
                }
            }
        }
        if(StringUtils.isNotEmpty(processVersionKey)&&CollectionUtils.isNotEmpty(list)){
            List<TaNodeConfigEntity> entities = this.findNodesByProcessVersionKey(processVersionKey);
            if(CollectionUtils.isNotEmpty(entities)){
                Map<String, TaNodeConfigEntity> map = entities.stream().collect(Collectors.toMap(TaNodeConfigEntity::getProcessNodeCode, Function.identity()));
                Collections.reverse(list);
               return list.stream().filter(o->map.containsKey(o)).map(o->{
                    TaNodeConfigEntity nodeConfigEntity = map.get(o);
                    return nodeConfigEntity;
                }).collect(Collectors.toList());
            }
        }
            return Lists.newArrayList();
        }

    /**
     * 通过版本查询节点
     * @param processVersionKey
     * @return
     */
    public List<TaNodeConfigEntity> findNodesByProcessVersionKey(String processVersionKey) {
        if (StringUtils.isNotEmpty(processVersionKey)) {
            List<TaNodeConfigEntity> entities = nodeConfigMapper.selectList(Wrappers.lambdaQuery(TaNodeConfigEntity.class).eq(TaNodeConfigEntity::getProcessVersionKey, processVersionKey));
            return entities;
        }
        return Lists.newArrayList();
    }
    /**
     * 根据流程实例id查询当前任务集合
     * @param processInstanceId
     * @return
     */
    public List<Task> findCurrentTasksByProcessInstanceId(String processInstanceId) {
        return  taskService.createTaskQuery().processInstanceId(processInstanceId).list();
    }

    /**
     * 解析按钮权限
     * @param btnAuth
     * @return
     */
    public List<OptBtnVO> parseBtnList(String btnAuth) {
        List<OptBtnVO> btnList = new ArrayList<>();
        if(StringUtils.isNotEmpty(btnAuth)){
            String[] btnStr = btnAuth.split(",");
            for (String btn : btnStr) {
                if (StringUtils.isNotEmpty(ColumnStr.PROCESS_BTN.getLabelByCode(btn))) {
                    OptBtnVO btnVO = new OptBtnVO();
                    btnVO.setBtnCode(btn);
                    btnVO.setBtnName(ColumnStr.PROCESS_BTN.getLabelByCode(btn));
                    btnList.add(btnVO);
                }
            }
        }
        return btnList;
    }

    /**
     * 通过用户编码集合查询用户集合
     * @param userNames
     * @return
     */
    public List<MdmUserPageRespVo> findUsersByCodeList(List<String> userNames){
        MdmUserPageReqVo userPageReqVo = new MdmUserPageReqVo();
        userPageReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        userPageReqVo.setPageSize(userNames.size());
        userPageReqVo.setUserNames(userNames);
        Result<PageResult<MdmUserPageRespVo>> pageResultResult = userFeign.pageList(userPageReqVo);
        PageResult<MdmUserPageRespVo> mdmUserPageRespVoPageResult = ApiResultUtil.objResult(pageResultResult, true);
        List<MdmUserPageRespVo> data = mdmUserPageRespVoPageResult.getData();
        AssertUtils.isTrue(userNames.size()==data.size(),"用户数据发生变更,请重新选择用户");
        return data;
    }

    /**
     * 通过任务id查询任务集合
     * @param taskId
     * @return
     */
    public List<TaTaskCommunicateEntity> findCommunicatesByTaskId(String taskId){
       return communicateMapper.selectList(Wrappers.lambdaQuery(TaTaskCommunicateEntity.class).eq(TaTaskCommunicateEntity::getTaskId,taskId));
    }


    public List<MdmPositionUserOrgRespVo> findUserByPositionCodes(Set<String> positionCodes) {
        MdmPositionUserOrgReqVo mdmPositionUserOrgReqVo = new MdmPositionUserOrgReqVo();
        mdmPositionUserOrgReqVo.setPositionCodeList(Lists.newArrayList(positionCodes));
        mdmPositionUserOrgReqVo.setUserEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<MdmPositionUserOrgRespVo> mdmPositionUserOrgRespVos = ApiResultUtil.objResult(positionFeign.findPositionUserOrgList(mdmPositionUserOrgReqVo), true);
        return mdmPositionUserOrgRespVos;
    }

    /**
     * 获取下一个用户任务用户组信息
     * @param  taskId     任务Id信息
     * @return  下一个用户任务用户组信息
     * @throws Exception
     */
    public TaskDefinition getNextTaskGroup(String taskId) throws Exception {

        ProcessDefinitionEntity processDefinitionEntity = null;

        String id = null;

        TaskDefinition task = null;

        //获取流程实例Id信息
        String processInstanceId = taskService.createTaskQuery().taskId(taskId).singleResult().getProcessInstanceId();

        //获取流程发布Id信息
        String definitionId = runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult().getProcessDefinitionId();

        processDefinitionEntity = (ProcessDefinitionEntity) ((RepositoryServiceImpl) repositoryService)
                .getDeployedProcessDefinition(definitionId);

        ExecutionEntity execution = (ExecutionEntity) runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();

        //当前流程节点Id信息
        String activitiId = execution.getActivityId();

        //获取流程所有节点信息
        List<ActivityImpl> activitiList = processDefinitionEntity.getActivities();

        //遍历所有节点信息
        for(ActivityImpl activityImpl : activitiList){
            id = activityImpl.getId();

            // 找到当前节点信息
            if (activitiId.equals(id)) {

                //获取下一个节点信息
                task = nextTaskDefinition(activityImpl, activityImpl.getId(), null, processInstanceId);

                break;
            }
        }

        return task;
    }
    /**
     * 下一个任务节点信息,
     *
     * 如果下一个节点为用户任务则直接返回,
     *
     * 如果下一个节点为排他网关, 获取排他网关Id信息, 根据排他网关Id信息和execution获取流程实例排他网关Id为key的变量值,
     * 根据变量值分别执行排他网关后线路中的el表达式, 并找到el表达式通过的线路后的用户任务信息
     * @param  activityImpl     流程节点信息
     * @param  activityId             当前流程节点Id信息
     * @param  elString               排他网关顺序流线段判断条件, 例如排他网关顺序留线段判断条件为${money>1000}, 若满足流程启动时设置variables中的money>1000, 则流程流向该顺序流信息
     * @param  processInstanceId      流程实例Id信息
     * @return
     */
    private TaskDefinition nextTaskDefinition(ActivityImpl activityImpl, String activityId, String elString, String processInstanceId){

        PvmActivity ac = null;

        Object s = null;

        //如果遍历节点为用户任务并且节点不是当前节点信息
        if("userTask".equals(activityImpl.getProperty("type")) && !activityId.equals(activityImpl.getId())){
            //获取该节点下一个节点信息
            TaskDefinition taskDefinition = ((UserTaskActivityBehavior)activityImpl.getActivityBehavior()).getTaskDefinition();
            return taskDefinition;
        }else{
            //获取节点所有流向线路信息
            List<PvmTransition> outTransitions = activityImpl.getOutgoingTransitions();
            List<PvmTransition> outTransitionsTemp = null;
            for(PvmTransition tr : outTransitions){
                ac = tr.getDestination(); //获取线路的终点节点
                //如果流向线路为排他网关
                if("exclusiveGateway".equals(ac.getProperty("type"))){
                    outTransitionsTemp = ac.getOutgoingTransitions();

                    //如果网关路线判断条件为空信息
                    if(StringUtils.isEmpty(elString)) {
                        //获取流程启动时设置的网关判断条件信息
                        elString = getGatewayCondition(ac.getId(), processInstanceId);
                    }

                    //如果排他网关只有一条线路信息
                    if(outTransitionsTemp.size() == 1){
                        return nextTaskDefinition((ActivityImpl)outTransitionsTemp.get(0).getDestination(), activityId, elString, processInstanceId);
                    }else if(outTransitionsTemp.size() > 1){  //如果排他网关有多条线路信息
                        for(PvmTransition tr1 : outTransitionsTemp){
                            s = tr1.getProperty("conditionText");  //获取排他网关线路判断条件信息
                            //判断el表达式是否成立
                            if(isCondition(ac.getId(), StringUtils.trim(s.toString()), elString)){
                                return nextTaskDefinition((ActivityImpl)tr1.getDestination(), activityId, elString, processInstanceId);
                            }
                        }
                    }
                }else if("userTask".equals(ac.getProperty("type"))){
                    return ((UserTaskActivityBehavior)((ActivityImpl)ac).getActivityBehavior()).getTaskDefinition();
                }else{
                }
            }
            return null;
        }
    }
    /**
     * 根据key和value判断el表达式是否通过信息
     * @param  key    el表达式key信息
     * @param  el     el表达式信息
     * @param  value  el表达式传入值信息
     * @return
     */
    public boolean isCondition(String key, String el, String value) {
        ExpressionFactory factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.setVariable(key, factory.createValueExpression(value, String.class));
        ValueExpression e = factory.createValueExpression(context, el, boolean.class);
        return (Boolean) e.getValue(context);
    }
    /**
     * 查询流程启动时设置排他网关判断条件信息
     * @param  gatewayId          排他网关Id信息, 流程启动时设置网关路线判断条件key为网关Id信息
     * @param  processInstanceId  流程实例Id信息
     * @return
     */
    public String getGatewayCondition(String gatewayId, String processInstanceId) {
        Execution execution = runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
        return runtimeService.getVariable(execution.getId(), gatewayId).toString();
    }

    /**
     * 获取流程实例当前所有的待办任务的职位集合
     * @param processInstanceId
     * @return
     */
    public Map<String,Set<String>> getCurrentTaskAllPositions(String processInstanceId){
        UserRedis user = UserUtils.getUser();
        Map<String,Set<String>> map = Maps.newHashMap();
        if(StringUtils.isNotEmpty(processInstanceId)){
            List<Task> taskList = this.findCurrentTasksByProcessInstanceId(processInstanceId);
            if(CollectionUtils.isNotEmpty(taskList)){
                taskList.forEach(o->{
                    Set<String> positions=Sets.newHashSet();
                    if(StringUtils.isNotEmpty(o.getAssignee())){
                        positions.add(o.getAssignee());
                    }
                    List<IdentityLink> identityLinksForTask = taskService.getIdentityLinksForTask(o.getId());
                    identityLinksForTask.forEach(p->{
                        if(StringUtils.isNotEmpty(p.getUserId())){
                            positions.add(p.getUserId());
                        }
                        if(StringUtils.isNotEmpty(p.getGroupId())){
                            Set<String> posCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgAndBpmRoleCodeList(user.getOrgcode(), Lists.newArrayList(p.getGroupId())));
                            positions.addAll(posCodes);
                        }
                    });
                    map.put(o.getId(),positions);
                });
            }
        }
        return map;
    }

    public void setCurrentPositionAndUserByProcessInstanceId(ProcessInstanceQueryRespVo vo){
        if(StringUtils.equals(ActivitiOperateTypeEnum.COMMIT.getCode(),vo.getBpmStatus())&&StringUtils.equals(ProcessInstanceStatusEnum.ENABLE.getCode(),vo.getProcessInstanceStatus())){
            List<Task> tasks = this.findCurrentTasksByProcessInstanceId(vo.getProcessInstanceId());
            Set<String> posCodes=Sets.newHashSet();
            if(CollectionUtils.isNotEmpty(tasks)){
                tasks.forEach(o->{
                    if(StringUtils.isNotEmpty(o.getAssignee())){
                        posCodes.add(o.getAssignee());
                    }
                    List<IdentityLink> identityLinksForTask = taskService.getIdentityLinksForTask(o.getId());
                    if(CollectionUtils.isNotEmpty(identityLinksForTask)){
                        identityLinksForTask.forEach(r->{
                            if(StringUtils.isNotEmpty(r.getUserId())){
                                posCodes.add(r.getUserId());
                            }
                            if(StringUtils.isNotEmpty(r.getGroupId())){
                                Set<String> positionCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, Lists.newArrayList(r.getGroupId())),false);
                                posCodes.addAll(positionCodes);
                            }
                        });
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(posCodes)){
                MdmPositionUserOrgReqVo mdmPositionUserOrgReqVo=new MdmPositionUserOrgReqVo();
                mdmPositionUserOrgReqVo.setPositionCodeList(Lists.newArrayList(posCodes));
                List<MdmPositionUserOrgRespVo> mdmPositionUserOrgRespVos = ApiResultUtil.objResult(positionFeign.findPositionUserOrgList(mdmPositionUserOrgReqVo), false);
                if(CollectionUtils.isNotEmpty(mdmPositionUserOrgRespVos)){
                    StringBuffer positionBuffer = new StringBuffer();
                    StringBuffer userBuffer = new StringBuffer();
                    mdmPositionUserOrgRespVos.forEach(o->{
                        userBuffer.append(o.getUserName()).append("(").append(o.getFullName()).append(")").append(",");
                        positionBuffer.append(o.getPositionName()).append("(").append(o.getPositionCode()).append(")").append(",");
                    });
                    vo.setCurrentTaskPositionName(positionBuffer.toString());
                    vo.setCurrentTaskUserName(userBuffer.toString());
                }
            }
        }
    }
    public void listMyBpmSetCurrentPositionAndUserByProcessInstanceId(CurrentTaskVo vo){
        if(StringUtils.equals(ActivitiOperateTypeEnum.COMMIT.getCode(),vo.getBpmStatus())&&StringUtils.equals(ProcessInstanceStatusEnum.ENABLE.getCode(),vo.getProcessInstanceStatus())){
            List<Task> tasks = this.findCurrentTasksByProcessInstanceId(vo.getProcessInstanceId());
            Set<String> posCodes=Sets.newHashSet();
            if(CollectionUtils.isNotEmpty(tasks)){
                tasks.forEach(o->{
                    if(StringUtils.isNotEmpty(o.getAssignee())){
                        posCodes.add(o.getAssignee());
                    }
                    List<IdentityLink> identityLinksForTask = taskService.getIdentityLinksForTask(o.getId());
                    if(CollectionUtils.isNotEmpty(identityLinksForTask)){
                        identityLinksForTask.forEach(r->{
                            if(StringUtils.isNotEmpty(r.getUserId())){
                                posCodes.add(r.getUserId());
                            }
                            if(StringUtils.isNotEmpty(r.getGroupId())){
                                Set<String> positionCodes = ApiResultUtil.objResult(positionFeign.findPositionCodeSetByOrgParentAndBpmRoleCodeList(null, Lists.newArrayList(r.getGroupId())),false);
                                posCodes.addAll(positionCodes);
                            }
                        });
                    }
                });
            }
            if(CollectionUtils.isNotEmpty(posCodes)){
                MdmPositionUserOrgReqVo mdmPositionUserOrgReqVo=new MdmPositionUserOrgReqVo();
                mdmPositionUserOrgReqVo.setPositionCodeList(Lists.newArrayList(posCodes));
                List<MdmPositionUserOrgRespVo> mdmPositionUserOrgRespVos = ApiResultUtil.objResult(positionFeign.findPositionUserOrgList(mdmPositionUserOrgReqVo), false);
                if(CollectionUtils.isNotEmpty(mdmPositionUserOrgRespVos)){
                    StringBuffer positionBuffer = new StringBuffer();
                    StringBuffer userBuffer = new StringBuffer();
                    mdmPositionUserOrgRespVos.forEach(o->{
                        userBuffer.append(o.getUserName()).append("(").append(o.getFullName()).append(")").append(",");
                        positionBuffer.append(o.getPositionName()).append("(").append(o.getPositionCode()).append(")").append(",");
                    });
                    vo.setCurrentTaskPositionName(positionBuffer.toString());
                    vo.setCurrentTaskUserName(userBuffer.toString());
                }
            }
        }
    }
}
