package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.ActivitiCurrentTaskEntity;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.ActivitiCurrentTaskService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.mdm.function.MdmFunctionFeign;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.FormParamQueryRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessFileInfoRspVO;
import com.biz.crm.nebular.activiti.vo.ActivitiCurrentTaskVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.Removal;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.activiti.service.impl
 * @Description: TODO
 * @date 2021/4/22 下午7:02
 */
@Service
@ConditionalOnMissingBean(name = "ActivitiTaskExpandServiceImpl")
@Slf4j
public class ActivitiTaskServiceImpl implements ActivitiTaskService {
    @Autowired
    private ActivitiCurrentTaskService activitiCurrentTaskService;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private MdmFunctionFeign mdmFunctionFeign;

    @Resource
    private ActivitiBusinessService activitiBusinessService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveTask(ActivitiCurrentTaskVo activitiCurrentTaskVo) {
        log.info("保存当前任务");
        //当前任务
        ActivitiCurrentTaskEntity activitiCurrentTaskEntity = new ActivitiCurrentTaskEntity();
        BeanUtils.copyProperties(activitiCurrentTaskVo, activitiCurrentTaskEntity);
        activitiCurrentTaskEntity.setTaskNo(CodeUtil.getCodeDefault());
        activitiCurrentTaskService.saveCurrentTask(activitiCurrentTaskEntity);
    }

    /**
     * 查询流程表单参数
     *
     * @param reqVO
     * @return
     */
    @Override
    public FormParamQueryRspVO getProcessFormParam(FormParamQueryReqVO reqVO) {
        AssertUtils.isNotEmpty(reqVO.getProcessInstanceId(), "流程实例ID[processInstanceId]不能为空");

        FormParamQueryRspVO rspVO = new FormParamQueryRspVO();

        ActivitiBusinessEntity businessEntity = helper.findActivitiBusinessEntityByInstanceId(reqVO.getProcessInstanceId());
        AssertUtils.isNotNull(businessEntity, "流程实例id：" + reqVO.getProcessInstanceId() + "对应的流程数据不存在");
        if (StringUtils.isNotEmpty(businessEntity.getMenuCode())) {
            //有菜单编码，则调用feign接口获取urlParam
            MdmFunctionReqVo reqVo = new MdmFunctionReqVo();
            reqVo.setFunctionCode(businessEntity.getMenuCode());
            MdmFunctionRespVo mdmFunctionRespVo = ApiResultUtil.objResult(mdmFunctionFeign.query(reqVo));
            if (ObjectUtils.isNotNull(mdmFunctionRespVo) && StringUtils.isNotEmpty(mdmFunctionRespVo.getRelationBillCode())) {
                rspVO.setUrlParam(mdmFunctionRespVo.getRelationBillCode());
            }
        }
        rspVO.setId(businessEntity.getBusinessId());
        rspVO.setStatus(false);
//        if (StringUtils.isNotEmpty(reqVO.getTaskId())) {
//            TaskInfo taskInfo = taTaskService.getTaskInfoByTaskId(reqVO.getTaskId());
//            if (taskInfo != null) {
//                TaNodeConfigEntity nodeConfig = taNodeConfigService.findNodeByTaskVersionKey(process.getProcessVersionKey(), taskInfo.getTaskDefinitionKey());
//                if (ObjectUtils.isNotNull(nodeConfig)) {
//                    rspVO.setFormRole(nodeConfig.getFormRole());
//                    if (StringUtils.isNotEmpty(nodeConfig.getFormRole()) && nodeConfig.getFormRole().contains("update")) {
//                        rspVO.setStatus(true);
//                    }
//                }
//            }
//        }
        if (StringUtils.isNotEmpty(reqVO.getCopyTaskId())) {
            rspVO.setStatus(false);
        }
        return rspVO;
    }

    @Override
    public ProcessFileInfoRspVO getProcessFileInfo(String businessId) {
        List<ActivitiBusinessEntity> activitiBusinessEntities = activitiBusinessService.getByBusinessId(businessId);
        if(CollectionUtils.isEmpty(activitiBusinessEntities)){
            return new ProcessFileInfoRspVO();
        }
        ProcessFileInfoRspVO fileInfoRspVO = CrmBeanUtil.copy(activitiBusinessEntities.get(0), ProcessFileInfoRspVO.class);
        fileInfoRspVO.setActivityRemarks(activitiBusinessEntities.get(0).getRemarks());
        fileInfoRspVO.setStartFiles(helper.findActFileByProcessInstanceIds(Collections.singletonList(fileInfoRspVO.getProcessInstanceId()), 1));
        return fileInfoRspVO;
    }
}
