package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaActFileEntity;
import com.biz.crm.activiti.mapper.TaActFileMapper;
import com.biz.crm.activiti.service.ITaActFileService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.act.req.TaActFileReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import javax.annotation.Resource;
import java.util.List;

/**
 * 接口实现
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="TaActFileServiceExpandImpl")
public class TaActFileServiceImpl<M extends BaseMapper<T>,T> extends ServiceImpl<TaActFileMapper, TaActFileEntity> implements ITaActFileService {

    @Resource
    private TaActFileMapper taActFileMapper;

    /**
     * 列表(目前必须通过流程实例id查)
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TaActFileRespVo> findList(TaActFileReqVo reqVo){
        AssertUtils.isNotEmpty(reqVo.getProcessInstId(),"查询流程文件时,流程实例id不能为空");
        Page<TaActFileRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<TaActFileRespVo> list = taActFileMapper.findList(page, reqVo);
        return PageResult.<TaActFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return taActFileRespVo
     */
    @Override
    public TaActFileRespVo query(TaActFileReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TaActFileReqVo reqVo){
        TaActFileEntity entity = CrmBeanUtil.copy(reqVo,TaActFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TaActFileReqVo reqVo){
        TaActFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(TaActFileReqVo reqVo){
        List<TaActFileEntity> taActFileEntities = taActFileMapper.selectBatchIds(reqVo.getIds());
        if(CollectionUtils.isNotEmpty(taActFileEntities)){
            taActFileEntities.forEach(o -> {

            });
        }
        this.updateBatchById(taActFileEntities);
    }

    /**
     * 启用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TaActFileReqVo reqVo){

    }

    /**
     * 禁用
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TaActFileReqVo reqVo){
        //设置状态为禁用
    }
}
