package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.TaActTargetEntity;
import com.biz.crm.activiti.mapper.TaActTargetMapper;
import com.biz.crm.activiti.service.ITaActTargetService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.activiti.act.req.TaActTargetReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActTargetRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 接口实现
 *
 * @author jerry7
 * @date 2021-01-14 18:17:13
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "TaActTargetExpandServiceImpl")
public class TaActTargetServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<TaActTargetMapper, TaActTargetEntity> implements ITaActTargetService {

    @Resource
    private TaActTargetMapper taActTargetMapper;

    /**
     * 列表
     *
     * @param reqVo
     * @return
     */
    @Override
    public PageResult<TaActTargetRespVo> findList(TaActTargetReqVo reqVo) {
        Page<TaActTargetRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<TaActTargetRespVo> list = taActTargetMapper.findList(page, reqVo);
        list.forEach(respVo -> respVo.setVisibleName(GlobalWhetherEnum.getDesByCode(respVo.getVisible())));
        return PageResult.<TaActTargetRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public List<TaActTargetRespVo> findByProcessKey(String procInstId) {
        List<TaActTargetRespVo> list=  taActTargetMapper.findByProcessKey(procInstId);
        list.forEach(respVo -> respVo.setVisibleName(GlobalWhetherEnum.getDesByCode(respVo.getVisible())));
        return list;
    }

    /**
     * 查询
     *
     * @param id
     * @return taActFileRespVo
     */
    @Override
    public TaActTargetRespVo query(String id) {
        TaActTargetEntity taActTargetEntity = this.getById(id);
        if (ObjectUtils.isNotNull(taActTargetEntity)) {
            TaActTargetRespVo respVo = CrmBeanUtil.copy(taActTargetEntity, TaActTargetRespVo.class);
            respVo.setVisibleName(GlobalWhetherEnum.getDesByCode(respVo.getVisible()));
            return respVo;
        }
        return null;
    }

    /**
     * 新增
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void save(TaActTargetReqVo reqVo) {
        TaActTargetEntity entity = CrmBeanUtil.copy(reqVo, TaActTargetEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(TaActTargetReqVo reqVo) {
        TaActTargetEntity entity = CrmBeanUtil.copy(reqVo, TaActTargetEntity.class);
        this.saveOrUpdate(entity);

    }

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteBatch(List<String> ids) {
        List<TaActTargetEntity> taActFileEntities = taActTargetMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty(taActFileEntities)) {
            taActFileEntities.forEach(o -> {
                this.removeById(o.getId());
            });
        }
        this.updateBatchById(taActFileEntities);
    }

    /**
     * 启用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enableBatch(TaActTargetReqVo reqVo) {

    }

    /**
     * 禁用
     *
     * @param reqVo
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disableBatch(TaActTargetReqVo reqVo) {
        //设置状态为禁用
    }
}
