package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.entity.TaTaskCommunicateEntity;
import com.biz.crm.activiti.mapper.TaTaskCommunicateMapper;
import com.biz.crm.activiti.service.ITaTaskCommunicateService;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.ConfirmCommunicateReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Sets;
import com.sun.org.apache.xpath.internal.operations.String;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author weston
 * @date 2021-01-04
 */
@Service("taTaskCommunicateService")
public class TaTaskCommunicateServiceImpl extends ServiceImpl<TaTaskCommunicateMapper, TaTaskCommunicateEntity> implements ITaTaskCommunicateService {
    @Resource
    private TaTaskCommunicateMapper communicateMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private ActivitiBusinessHelper helper;
    @Autowired
    private ActivitiBpmlogService logService;

//    @Autowired
//    private ITaProcessOptRecordService taProcessOptRecordService;

    /**
     * 发起沟通
     * @param reqVO
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#reqVO.taskId"}, waitTime = 60, leaseTime = 300)
    public void communicateTo(TaskCommunicateReqVO reqVO) {
        AssertUtils.isNotEmpty(reqVO.getTaskId(), "任务id[taskId]不能为空");
        AssertUtils.isNotEmpty(reqVO.getContent(), "沟通内容[content]不能为空!");
        AssertUtils.isNotEmpty(reqVO.getTargetUserNames(), "沟通目标用户[targetUserCodes]不能为空!");
        AssertUtils.isTrue(reqVO.getTargetUserNames().size()== Sets.newHashSet(reqVO.getTargetUserNames()).size(),"请勿选择重复的用户");
        Task task = helper.findCurrentTaskByTaskId(reqVO.getTaskId());
        AssertUtils.isNotNull(task,"当前任务已经不存在,请刷新后再操作");
        ActivitiBusinessEntity businessEntity = helper.findActivitiBusinessEntityByInstanceId(task.getProcessInstanceId());
        UserRedis currentUser = UserUtils.getUser();
        List<MdmUserPageRespVo> users = helper.findUsersByCodeList(reqVO.getTargetUserNames());
        //保存沟通任务
        List<TaTaskCommunicateEntity> communicateEntities = users.stream().map(user -> {
            TaTaskCommunicateEntity communicate = new TaTaskCommunicateEntity();
            communicate.setContent(reqVO.getContent());
            communicate.setTargetUserCode(user.getUserName());
            communicate.setTargetUserName(user.getFullName());
            communicate.setTargetPosCode(user.getPositionCode());
            communicate.setTargetPosName(user.getPositionName());
            communicate.setTargetOrgCode(user.getOrgCode());
            communicate.setTargetOrgName(user.getOrgName());
            communicate.setProcessInstanceId(task.getProcessInstanceId());
            communicate.setCrmProcessInstanceId(businessEntity.getCrmProcessInstanceId());
            communicate.setTaskId(reqVO.getTaskId());
            communicate.setTaskDefKey(task.getTaskDefinitionKey());
            communicate.setTaskName(task.getName());
            communicate.setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
            communicate.setIsNeedReply(Optional.ofNullable(reqVO.getIsNeedReply()).orElse(GlobalWhetherEnum.NO.getCode()));
            return communicate;
        }).collect(Collectors.toList());
        this.saveBatch(communicateEntities);
        //保存流程日志
        TaNodeConfigEntity nodeConfigEntity = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), task.getTaskDefinitionKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                .businessId(businessEntity.getBusinessId())
                .businessNo(businessEntity.getBusinessNo())
                .crmProcessInstanceId(businessEntity.getCrmProcessInstanceId())
                .operateType(ActivitiOperateTypeEnum.COMMUNICATE.getCode())
                .taskId(reqVO.getTaskId())
                .processInstanceId(task.getProcessInstanceId())
                .nodeName(task.getName())
                .nodeCode(task.getTaskDefinitionKey())
                .nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId():null)
                .build();
        bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.COMMUNICATE.getCode(),currentUser.getPoscode(),false));
        logService.commomSaveLog(bpmlogVo);
    }

    /**
     * 确认沟通
     * @param reqVO
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    @Klock(keys = {"#reqVO.communicateId"}, waitTime = 60, leaseTime = 300)
    public void confirmCommunicate(ConfirmCommunicateReqVO reqVO) {
        AssertUtils.isNotEmpty(reqVO.getCommunicateId(), "沟通任务id[communicateId]不能为空");
        AssertUtils.isNotEmpty(reqVO.getContent(), "沟通内容[content]不能为空");
        TaTaskCommunicateEntity taTaskCommunicateEntity = communicateMapper.selectById(reqVO.getCommunicateId());
        AssertUtils.isNotNull(taTaskCommunicateEntity, "沟通任务不存在");
        if(Objects.equals(Indicator.COPY_TASK_STATUS_READ.getCode(),taTaskCommunicateEntity.getStatus())){
            //如果已经沟通确认过了直接返回
            return;
        }
        UserRedis user = UserUtils.getUser();
        AssertUtils.isTrue(StringUtils.equals(user.getUsername(),taTaskCommunicateEntity.getTargetUserCode()),"当前用户没有确认沟通的权限");
        taTaskCommunicateEntity.setStatus(Indicator.COPY_TASK_STATUS_READ.getCode());
        this.updateById(taTaskCommunicateEntity);
        // 新增一条流程操作记录
        ActivitiBusinessEntity businessEntity = helper.findActivitiBusinessEntityByInstanceId(taTaskCommunicateEntity.getProcessInstanceId());
        //保存流程日志
        TaNodeConfigEntity nodeConfigEntity = helper.findNodeByProcessVersionKeyAndNodeCode(businessEntity.getProcessVersionKey(), taTaskCommunicateEntity.getTaskDefKey());
        ActivitiBpmlogVo bpmlogVo = ActivitiBpmlogVo.builder()
                .businessId(businessEntity.getBusinessId())
                .businessNo(businessEntity.getBusinessNo())
                .crmProcessInstanceId(businessEntity.getCrmProcessInstanceId())
                .operateType(ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode())
                .taskId(reqVO.getCommunicateId())
                .processInstanceId(businessEntity.getProcessInstanceId())
                .nodeName(nodeConfigEntity.getProcessNodeName())
                .nodeCode(taTaskCommunicateEntity.getTaskDefKey())
                .nodeId(Objects.nonNull(nodeConfigEntity) ? nodeConfigEntity.getProcessNodeId():null)
                .build();
        bpmlogVo.setRemarks(helper.getProcessOperateLogDesc(ActivitiOperateTypeEnum.CONFIRM_COMMUNICATE.getCode(),user.getPoscode(),false));
        bpmlogVo.setContent(reqVO.getContent());
        logService.commomSaveLog(bpmlogVo);
    }
}
