package com.biz.crm.activiti.util;

import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author weston
 * @date 2020-12-02
 */
public class XmlActivitiUtil {

    // 流程开始默认监听器ID
    public static final String ID_DEF_START = "402885605bfb8622015bfb8bb4400000";
    // 流程结束默认监听器ID
    public static final String ID_DEF_END = "402885605bfb8622015bfb8c7aeb0001";
    // 任务创建默认监听器ID
    public static final String ID_DEF_CREATE = "402885605bfb8622015bfb8da5c60002";
    // 任务完成默认监听器ID
    public static final String ID_DEF_COMPLETE = "402885605bfb8622015bfb8fa2c00004";

    // 发起节点默认创建监听器
    public static final String ID_DEF_START_TASK_LISTENER = "86378d438ca2758220a51c29bab68d2d";
    // 通用流程结束监听器ID
    public static final String ID_DEF_END_PROCESS_LISTENER = "f6cdcf77b960f0fc1f18809ab72c0527";

    // 流程开始默认监听器名
    public static final String CLASS_DEF_START =
            "com.biz.crm.listener.base.DefaultExeStartListener";
    // 流程结束默认监听器名
    public static final String CLASS_DEF_END =
            "com.biz.crm.listener.base.DefaultExeEndListener";
    // 任务创建默认监听器名
    public static final String CLASS_DEF_CREATE =
            "com.biz.crm.listener.base.DefaultTaskCreateListener";
    // 任务完成默认监听器名
    public static final String CLASS_DEF_COMPLETE =
            "com.biz.crm.listener.base.DefaultTaskCompleteListener";

    // 是否会签
    public static final String ASSIGNEE_PROP_IS_SEQ = "isSequential";
    // 会签属性--次数
    public static final String ASSIGNEE_PROP_LOOP = "loopCardinality";
    // 会签属性--集合名称
    public static final String ASSIGNEE_PROP_CLC = "collection";
    // 会签属性--元素变量
    public static final String ASSIGNEE_PROP_VAR = "elementVariable";
    // 会签属性--完成条件
    public static final String ASSIGNEE_PROP_CC = "completionCondition";

    /**
     * 获得流程节点人员审批设置值和类型
     *
     * @param xml
     * @return
     * @throws Exception
     */
    public static Map<String, String> getActNodeUserRoles(String xml) throws Exception {
        Map<String, String> map = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        // 用户任务
        @SuppressWarnings("unchecked")
        List<Element> userTaskElements = processElement.elements("userTask");
        for (Element userTaskElement : userTaskElements) {
            String nodeId = userTaskElement.attributeValue("id");
            String roleAttribute = userTaskElement.attributeValue("candidateGroups");
            String usersAttribute = userTaskElement.attributeValue("candidateUsers");
            String assigneeAttribute = userTaskElement.attributeValue("assignee");
            if (StringUtils.isNotEmpty(roleAttribute)) {
                map.put(nodeId, "R" + roleAttribute);
            } else if (StringUtils.isNotEmpty(usersAttribute)) {
                map.put(nodeId, "O" + usersAttribute);
            } else if (StringUtils.isNotEmpty(assigneeAttribute)) {
                map.put(nodeId, "P" + assigneeAttribute);
            }
        }
        return map;
    }

    /**
     * 默认新增默认的监听器
     * 排序问题会导致第一次创建的xml文件无法正常发布，修改排序
     *
     * @param xml
     * @return
     */
    @SuppressWarnings("unchecked")
    public static String addDefListenerXml(String xml) throws Exception {
        SAXReader reader = new SAXReader();
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        Element extensionElements = processElement.element("extensionElements");
        // 流程开始、结束监听
        if (extensionElements == null) {
            //获取描述
            Element documentElement = processElement.element("documentation");
            //暂时删除，后续重新加入
            processElement.remove(documentElement);
            //复制process
            Element processNewElement = processElement.createCopy();
            //清除原有的process内容，方便重新按照顺序添加
            processElement.clearContent();
            //首先加入描述
            processElement.add(documentElement.createCopy());
            //加入监听器
            Element newExtensionElements = processElement.addElement("extensionElements");
            addListenerElement(
                    newExtensionElements, "executionListener", ID_DEF_START, "start", CLASS_DEF_START);
            addListenerElement(
                    newExtensionElements, "executionListener", ID_DEF_END, "end", CLASS_DEF_END);
            //把原有的element装入新的element
            processNewElement.elements().forEach(element -> {
                processElement.add(element.createCopy());
            });
        } else {
            List<Element> eElements = extensionElements.elements();
            boolean haveStart = false;
            boolean haveEnd = false;
            for (Element eElement : eElements) {
                if (CLASS_DEF_START.equals(eElement.attributeValue("class"))) {
                    haveStart = true;
                } else if (CLASS_DEF_END.equals(eElement.attributeValue("class"))) {
                    haveEnd = true;
                }
            }
            if (!haveStart) {
                addListenerElement(extensionElements, "executionListener", ID_DEF_START, "start", CLASS_DEF_START);
            }
            if (!haveEnd) {
                addListenerElement(extensionElements, "executionListener", ID_DEF_END, "end", CLASS_DEF_END);
            }
        }
        // 用户任务
        List<Element> userTaskElements = processElement.elements("userTask");
        for (Element userTaskElement : userTaskElements) {
            Element lisElements = userTaskElement.element("extensionElements");
            if (lisElements == null) {
                Element newTaskElements = userTaskElement.addElement("extensionElements");
                addListenerElement(
                        newTaskElements, "taskListener", ID_DEF_CREATE, "create", CLASS_DEF_CREATE);
                addListenerElement(
                        newTaskElements, "taskListener", ID_DEF_COMPLETE, "complete", CLASS_DEF_COMPLETE);
            } else {
                List<Element> eElements = lisElements.elements();
                boolean haveCreate = false;
                boolean haveComplete = false;
                for (Element eElement : eElements) {
                    if (CLASS_DEF_CREATE.equals(eElement.attributeValue("class"))) {
                        haveCreate = true;
                    } else if (CLASS_DEF_COMPLETE.equals(eElement.attributeValue("class"))) {
                        haveComplete = true;
                    }
                }
                if (!haveCreate) {
                    addListenerElement(lisElements, "taskListener", ID_DEF_CREATE, "create", CLASS_DEF_CREATE);
                }
                if (!haveComplete) {
                    addListenerElement(lisElements, "taskListener", ID_DEF_COMPLETE, "complete", CLASS_DEF_COMPLETE);
                }
            }
        }
        return document.asXML();
    }

    /**
     * 为元素新增默认监听器
     *
     * @param element
     * @param type
     * @param id
     * @param event
     * @param clazz
     * @throws Exception
     */
    private static void addListenerElement(Element element, String type,
                                           String id, String event, String clazz) throws Exception {
        Element newElement = element.addElement("activiti:" + type);
        newElement.addAttribute("id", id);
        newElement.addAttribute("event", event);
        newElement.addAttribute("class", clazz);
    }

    /**
     * 会签配置写入xml
     *
     * @param xml
     * @return
     */
    @SuppressWarnings("unchecked")
    public static String addMultiInstanceProperties(String xml, Map<String, Map<String, String>> nodePropertiesMap) throws Exception {
        SAXReader reader = new SAXReader();
        InputStream inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        List<Element> taskList = processElement.elements("userTask");
        if (CollectionUtils.isNotEmpty(taskList)) {
            for (Element element : taskList) {
                String taskId = element.attributeValue("id");
                if (nodePropertiesMap.containsKey(taskId)) {
                    setTaskAssignee(nodePropertiesMap, element, taskId);
                }
                //setTaskDocumentation(element);
            }
        }
        return document.asXML();
    }

    /**
     * 会签属性配置
     *
     * @param nodePropertiesMap
     * @param element
     * @param taskId
     */
    private static void setTaskAssignee(Map<String, Map<String, String>> nodePropertiesMap, Element element, String taskId) {
        Map<String, String> taskProperties = nodePropertiesMap.get(taskId);
        if (taskProperties.containsKey(ASSIGNEE_PROP_IS_SEQ)) {// 如果会签属性不是非空，是并行或者串行
            // 获得multiInstanceLoopCharacteristics配置节点，没有就新建一个
            Element newTaskElement = element.element("multiInstanceLoopCharacteristics");
            if (newTaskElement == null) {
                newTaskElement = element.addElement("multiInstanceLoopCharacteristics");
            }

            newTaskElement.addAttribute(ASSIGNEE_PROP_IS_SEQ, taskProperties.get(ASSIGNEE_PROP_IS_SEQ));// 并行串行
            Element loopElement = newTaskElement.element(ASSIGNEE_PROP_LOOP);
            Element conditionElement = newTaskElement.element(ASSIGNEE_PROP_CC);
            if (taskProperties.containsKey(ASSIGNEE_PROP_LOOP)) {// 如果有循环次数，则设置数字值，和集合名称和变量是互斥的
                if (loopElement == null) {
                    loopElement = newTaskElement.addElement(ASSIGNEE_PROP_LOOP);
                }
                loopElement.setText(taskProperties.get(ASSIGNEE_PROP_LOOP));// 设置循环次数
            } else if (loopElement != null) {// 如果这次没得，而历史xml又记录得有
                newTaskElement.remove(loopElement);
            }

            if (taskProperties.containsKey(ASSIGNEE_PROP_CLC)) {
                newTaskElement.addAttribute(ASSIGNEE_PROP_CLC, taskProperties.get(ASSIGNEE_PROP_CLC));// 集合名称
            } else {
                deleteElementAttribute(newTaskElement, ASSIGNEE_PROP_CLC);
            }
            if (taskProperties.containsKey(ASSIGNEE_PROP_VAR)) {
                newTaskElement.addAttribute(ASSIGNEE_PROP_VAR, taskProperties.get(ASSIGNEE_PROP_VAR));//遍历集合的元素变量
            } else {
                deleteElementAttribute(newTaskElement, ASSIGNEE_PROP_VAR);
            }

            if (taskProperties.containsKey(ASSIGNEE_PROP_CC)) {// 如果有结束条件
                // 先转化： ==或eq、!=或ne、<或lt、>或gt、<=或le、>=或ge
                String condition = convertEl(taskProperties.get(ASSIGNEE_PROP_CC));
                if (conditionElement == null) {
                    conditionElement = newTaskElement.addElement(ASSIGNEE_PROP_CC);
                }
                conditionElement.setText(condition);// 设置结束条件
            } else {
                if (conditionElement != null) {
                    newTaskElement.remove(conditionElement);
                }
            }
        }
    }

    public static String convertEl(String elStr) {
        return elStr.replace("{eq}", "==").replace("{ne}", "!=")
                .replace("{le}", "<=").replace("{ge}", ">=").replace("{lt}", "<").replace("{gt}", ">");
    }

    public static void deleteElementAttribute(Element element, String attr) {
        Attribute attribute = element.attribute(attr);
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    public static List<TaNodeConfigEntity> getNodes(byte[] xmlByte) throws Exception {
        SAXReader reader = new SAXReader();
        InputStream inputStream = new ByteArrayInputStream(xmlByte);
        Document document = reader.read(inputStream);
        Element root = document.getRootElement();
        Element processElement = root.element("process");
        List<Element> userTaskElements = processElement.elements("userTask");
        if (CollectionUtils.isNotEmpty(userTaskElements)) {
            List<TaNodeConfigEntity> nodeConfigs = new ArrayList<>();
            for(int i =0 ;i<userTaskElements.size();i++){
                Element userTaskElement=userTaskElements.get(i);
                TaNodeConfigEntity node = new TaNodeConfigEntity();
                node.setProcessNodeCode(userTaskElement.attributeValue("id"));
                node.setProcessNodeName(userTaskElement.attributeValue("name"));
                node.setNodeIndex(userTaskElements.size()-i);
                nodeConfigs.add(node);
            }
            return nodeConfigs;
        }

        return null;
    }
}
