package com.biz.crm.bpmlog.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.entity.TaNodeConfigEntity;
import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.mapper.ActivitiBusinessMapper;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.activiti.service.ActivityTaskUtil;
import com.biz.crm.activiti.service.ITaActFileService;
import com.biz.crm.activiti.service.impl.ActivitiBusinessHelper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.bpmlog.entity.ActivitiBpmlogEntity;
import com.biz.crm.bpmlog.mapper.ActivitiBpmlogMapper;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.bpmlog.vo.ActivitiBpmlogVo;
import com.biz.crm.copy.mapper.ActivitiCopyTaskMapper;
import com.biz.crm.copy.service.ActivitiCopyTaskService;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.*;
import com.google.common.collect.Lists;
import org.activiti.engine.*;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.task.Task;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.bpmlog.service.impl
 * @Description: TODO
 * @date 2021/4/22 下午2:22
 */
@Service
@ConditionalOnMissingBean(name = "ActivitiBpmlogExpandServiceImpl")
public class ActivitiBpmlogServiceImpl extends ServiceImpl<ActivitiBpmlogMapper, ActivitiBpmlogEntity> implements ActivitiBpmlogService {

    @Autowired
    private TaskService taskService;
    @Resource
    private ActivitiBpmlogMapper logMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;
    @Resource
    private ActivitiBusinessMapper activitiBusinessMapper;
    @Autowired
    private ActivitiBusinessHelper helper;

    @Override
    @Transactional
    public void commomSaveLog(ActivitiBpmlogVo activitiBpmlogVo) {
        ActivitiBpmlogEntity entity = new ActivitiBpmlogEntity();
        CrmBeanUtil.copyProperties(activitiBpmlogVo, entity);
        entity.setLogCode(CodeUtil.getCodeDefault());
        if(StringUtils.isEmpty(activitiBpmlogVo.getIsAutoExecute())){
            entity.setIsAutoExecute(GlobalWhetherEnum.NO.getCode());
        }
        this.save(entity);
    }

    @Override
    @Transactional
    public void commomSaveLog(String crmProcessInstanceId, String processInstanceId, String businessId,String businessNo, String remarks, String operateType) {
        ActivitiBpmlogVo activitiBpmlogVo = new ActivitiBpmlogVo(crmProcessInstanceId, processInstanceId,
                businessId,businessNo,  operateType);
        activitiBpmlogVo.setRemarks(remarks);
        this.commomSaveLog(activitiBpmlogVo);
    }

    /**
     * 查询流程日志
     * @param reqVO
     * @return
     */
    @Override
    public List<OptLogsRspVO> getOptLogs(OptRecordReqVO reqVO) {
        if (StringUtils.isEmpty(reqVO.getProcessNo()) && StringUtils.isEmpty(reqVO.getProcessInstanceId())&&StringUtils.isEmpty(reqVO.getFormNo())) {
            throw new BusinessException("查询流程日志时,流程编码[processNo]和流程实例id[processInstanceId]和业务单据id[formNo]不能同时为空");
        }
        List<OptLogsRspVO> respVos = Lists.newArrayList();
        if(StringUtils.isNotEmpty(reqVO.getProcessNo())){
            ActivitiBusinessEntity entity = activitiBusinessMapper.selectOne(Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, reqVO.getProcessNo()));
            reqVO.setFormNo(entity.getBusinessId());
        }
        //查询流程实例
        List<ActivitiBusinessEntity> activitiBusinessEntities = activitiBusinessMapper.selectList(Wrappers.lambdaQuery(ActivitiBusinessEntity.class)
                .eq(StringUtils.isNotEmpty(reqVO.getProcessInstanceId()), ActivitiBusinessEntity::getProcessInstanceId, reqVO.getProcessInstanceId())                 .eq(StringUtils.isNotEmpty(reqVO.getFormNo()),ActivitiBusinessEntity::getBusinessId,reqVO.getFormNo()).orderByDesc(ActivitiBusinessEntity::getCreateDateAll));
        if(CollectionUtils.isEmpty(activitiBusinessEntities)){
            return Lists.newArrayList();
        }
        Map<String, ActivitiBusinessEntity> businessEntityMap = activitiBusinessEntities.stream().collect(Collectors.toMap(ActivitiBusinessEntity::getCrmProcessInstanceId, Function.identity()));
        //查询已处理的日志
        List<ActivitiBpmlogEntity> logEntities = logMapper.selectList(Wrappers.lambdaQuery(ActivitiBpmlogEntity.class)
                .eq(StringUtils.isNotEmpty(reqVO.getProcessInstanceId()), ActivitiBpmlogEntity::getProcessInstanceId, reqVO.getProcessInstanceId())
                .eq(StringUtils.isNotEmpty(reqVO.getFormNo()),ActivitiBpmlogEntity::getBusinessId,reqVO.getFormNo())
                .orderByDesc(ActivitiBpmlogEntity::getLogCode)
        );

        //查询当前任务处理节点
        List<Task> taskList = taskService.createTaskQuery().processInstanceId(activitiBusinessEntities.get(0).getProcessInstanceId()).orderByTaskCreateTime().desc().list();
        if (CollectionUtils.isNotEmpty(taskList)) {
            ActivitiBusinessEntity activitiBusinessEntity = activitiBusinessEntities.get(0);
            OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
            List<OptRecordRspVO> collect=Lists.newArrayList();
            //要先把当前处理节点的后续节点查询出来放在最前面
            List<TaNodeConfigEntity> nodes=helper.findFutureNodesByProcessVersionKey(activitiBusinessEntity.getProcessVersionKey(),taskList);
            if(CollectionUtils.isNotEmpty(nodes)){
                nodes.stream().forEach(o->{
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setTaskDefKey(o.getProcessNodeCode());
                    rspVO.setCreateTime(new Date());
                    rspVO.setTaskName(o.getProcessNodeName());
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setContent("待处理节点");
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setId(o.getId());
                    rspVO.setOperation("BTN_999");
                    rspVO.setOperationStr("待处理");
                    rspVO.setUserName("");
                    collect.add(rspVO);
                });
            }
            taskList.stream().forEach(o -> {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                //根据任务获取当前任务的审批岗位名称和岗位编码
                helper.setCurrentTaskPosition(rspVO,o);
                rspVO.setCreateTime(new Date());
                rspVO.setTaskDefKey(o.getTaskDefinitionKey());
                rspVO.setTaskName(o.getName());
                rspVO.setTaskId(o.getId());
                rspVO.setProcessVersionKey(o.getProcessDefinitionId());
                rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setContent("当前待办节点");
                rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                rspVO.setId(o.getId());
                rspVO.setOperationStr("待处理");
                rspVO.setUserName(Optional.ofNullable(rspVO.getCurrentAccounts()).orElse(""));
                collect.add(rspVO);
            });
            //未处理的时间表头都搞成当前时间,后续再商定怎么设值
            String date = DateUtil.formatDate(new Date(), DateUtil.DEFAULT_DAY_PATTERN);
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setOptRecordRspVOList(collect);
            respVos.add(optLogsRspVO);
        }
        //查询流程处理日志文件
        List<TaActFileRespVo> actFileRespVos = helper.findActFileByProcessInstanceIds(activitiBusinessEntities.stream().map(ActivitiBusinessEntity::getProcessInstanceId).collect(Collectors.toList()),2);
        Map<String, List<TaActFileRespVo>> fileMap = actFileRespVos.stream().collect(Collectors.groupingBy(o->o.getProcessInstId()+o.getNodeId()));
        //按照日志的创建时间分组
        Set<String> createDateSets = logEntities.stream().map(ActivitiBpmlogEntity::getCreateDate).collect(Collectors.toSet());
        List<String> createDateList = createDateSets.stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        Map<String, List<ActivitiBpmlogEntity>> map = logEntities.stream().collect(Collectors.groupingBy(ActivitiBpmlogEntity::getCreateDate));
        if (MapUtils.isNotEmpty(map)) {
            createDateList.forEach(key->{
                OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
                optLogsRspVO.setLogDate(key);
                List<ActivitiBpmlogEntity> value = map.get(key);
                List<OptRecordRspVO> recordRspVOS = value.stream().map(r -> {
                    ActivitiBusinessEntity activitiBusinessEntity = businessEntityMap.get(r.getCrmProcessInstanceId());
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setCreateTime(DateUtil.str2Date(r.getCreateDateAll(), DateUtil.datetimeFormat));
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setUserCode(r.getCreateCode());
                    rspVO.setTaskName(r.getNodeName());
                    rspVO.setPositionCode(r.getCreatePosCode());
                    rspVO.setContent(r.getRemarks());
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ActivitiOperateTypeEnum.getStatusNameByCode(r.getOperateType()));
                    if(StringUtils.equals(ActivitiOperateTypeEnum.COPY.getCode(),r.getOperateType())){
                        rspVO.setPositionName(null);
                        rspVO.setUserName(null);
                        rspVO.setCurrentAccounts(null);
                    }
                    if(StringUtils.contains(rspVO.getContent(),"系统自动执行")){
                        rspVO.setUserName("系统跳过");
                        rspVO.setCurrentAccounts("系统跳过");
                        rspVO.setPositionName("系统跳过");
                    }else if(StringUtils.contains(rspVO.getContent(),"系统自动抄送")){
                        rspVO.setUserName("系统抄送");
                        rspVO.setCurrentAccounts("系统抄送");
                        rspVO.setPositionName("系统抄送");
                    } else {
                        rspVO.setCurrentAccounts(r.getCreateName()+"("+r.getCreateCode()+")");
                        rspVO.setPositionName(r.getCreatePosName());
                        rspVO.setUserName(r.getCreateName());
                    }
                    //设置流程审批文件
                    if (MapUtils.isNotEmpty(fileMap)) {
                        List<TaActFileRespVo> taActFileRespVos = fileMap.get(r.getProcessInstanceId()+r.getNodeId());
                        rspVO.setFileList(Optional.ofNullable(taActFileRespVos).orElse(Lists.newArrayList()));
                    }
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setOptRecordRspVOList(recordRspVOS);
                respVos.add(optLogsRspVO);
            });
        }
        return respVos;
    }

    @Override
    public List<ActivitiBpmlogEntity> findLogByUserAndCrmProcessInstanceId(String crmProcessInstanceId) {
        List<ActivitiBpmlogEntity> bpmlogEntities = logMapper.selectList(Wrappers.lambdaQuery(ActivitiBpmlogEntity.class).eq(ActivitiBpmlogEntity::getCrmProcessInstanceId, crmProcessInstanceId));
        return bpmlogEntities;
    }

    @Override
    public List<OptLogsRspVO> getOptLogsOrderAsc(OptRecordReqVO reqVO) {
        if (StringUtils.isEmpty(reqVO.getProcessNo()) && StringUtils.isEmpty(reqVO.getProcessInstanceId())&&StringUtils.isEmpty(reqVO.getFormNo())) {
            throw new BusinessException("查询流程日志时,流程编码[processNo]和流程实例id[processInstanceId]和业务单据id[formNo]不能同时为空");
        }
        List<OptLogsRspVO> respVos = Lists.newArrayList();
        if(StringUtils.isNotEmpty(reqVO.getProcessNo())){
            ActivitiBusinessEntity entity = activitiBusinessMapper.selectOne(Wrappers.lambdaQuery(ActivitiBusinessEntity.class).eq(ActivitiBusinessEntity::getCrmProcessInstanceId, reqVO.getProcessNo()));
            reqVO.setFormNo(entity.getBusinessId());
        }
        //查询流程实例
        List<ActivitiBusinessEntity> activitiBusinessEntities = activitiBusinessMapper.selectList(Wrappers.lambdaQuery(ActivitiBusinessEntity.class)
                .eq(StringUtils.isNotEmpty(reqVO.getProcessInstanceId()), ActivitiBusinessEntity::getProcessInstanceId, reqVO.getProcessInstanceId())                 .eq(StringUtils.isNotEmpty(reqVO.getFormNo()),ActivitiBusinessEntity::getBusinessId,reqVO.getFormNo()).orderByDesc(ActivitiBusinessEntity::getCreateDateAll));
        if(CollectionUtils.isEmpty(activitiBusinessEntities)){
            return Lists.newArrayList();
        }
        Map<String, ActivitiBusinessEntity> businessEntityMap = activitiBusinessEntities.stream().collect(Collectors.toMap(ActivitiBusinessEntity::getCrmProcessInstanceId, Function.identity()));
        //查询已处理的日志
        List<ActivitiBpmlogEntity> logEntities = logMapper.selectList(Wrappers.lambdaQuery(ActivitiBpmlogEntity.class)
                .eq(StringUtils.isNotEmpty(reqVO.getProcessInstanceId()), ActivitiBpmlogEntity::getProcessInstanceId, reqVO.getProcessInstanceId())
                .eq(StringUtils.isNotEmpty(reqVO.getFormNo()),ActivitiBpmlogEntity::getBusinessId,reqVO.getFormNo())
                .orderByAsc(ActivitiBpmlogEntity::getLogCode)
        );

        //查询当前任务处理节点
        List<Task> taskList = taskService.createTaskQuery().processInstanceId(activitiBusinessEntities.get(0).getProcessInstanceId()).orderByTaskCreateTime().desc().list();

        //查询流程处理日志文件
        List<TaActFileRespVo> actFileRespVos = helper.findActFileByProcessInstanceIds(activitiBusinessEntities.stream().map(ActivitiBusinessEntity::getProcessInstanceId).collect(Collectors.toList()),2);
        Map<String, List<TaActFileRespVo>> fileMap = actFileRespVos.stream().collect(Collectors.groupingBy(o->o.getProcessInstId()+o.getNodeId()));
        //按照日志的创建时间分组
        Set<String> createDateSets = logEntities.stream().map(ActivitiBpmlogEntity::getCreateDate).collect(Collectors.toSet());
        List<String> createDateList = createDateSets.stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        Map<String, List<ActivitiBpmlogEntity>> map = logEntities.stream().collect(Collectors.groupingBy(ActivitiBpmlogEntity::getCreateDate));
        if (MapUtils.isNotEmpty(map)) {
            createDateList.forEach(key->{
                OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
                optLogsRspVO.setLogDate(key);
                List<ActivitiBpmlogEntity> value = map.get(key);
                List<OptRecordRspVO> recordRspVOS = value.stream().map(r -> {
                    ActivitiBusinessEntity activitiBusinessEntity = businessEntityMap.get(r.getCrmProcessInstanceId());
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setCreateTime(DateUtil.str2Date(r.getCreateDateAll(), DateUtil.datetimeFormat));
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setUserCode(r.getCreateCode());
                    rspVO.setTaskName(r.getNodeName());
                    rspVO.setPositionCode(r.getCreatePosCode());
                    rspVO.setContent(r.getRemarks());
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setOperation(r.getOperateType());
                    rspVO.setOperationStr(ActivitiOperateTypeEnum.getStatusNameByCode(r.getOperateType()));
                    if(StringUtils.equals(ActivitiOperateTypeEnum.COPY.getCode(),r.getOperateType())){
                        rspVO.setPositionName(null);
                        rspVO.setUserName(null);
                        rspVO.setCurrentAccounts(null);
                    }
                    if(StringUtils.contains(rspVO.getContent(),"系统自动执行")){
                        rspVO.setUserName("系统跳过");
                        rspVO.setCurrentAccounts("系统跳过");
                        rspVO.setPositionName("系统跳过");
                    }else if(StringUtils.contains(rspVO.getContent(),"系统自动抄送")){
                        rspVO.setUserName("系统抄送");
                        rspVO.setCurrentAccounts("系统抄送");
                        rspVO.setPositionName("系统抄送");
                    } else {
                        rspVO.setCurrentAccounts(r.getCreateName()+"("+r.getCreateCode()+")");
                        rspVO.setPositionName(r.getCreatePosName());
                        rspVO.setUserName(r.getCreateName());
                    }
                    //设置流程审批文件
                    if (MapUtils.isNotEmpty(fileMap)) {
                        List<TaActFileRespVo> taActFileRespVos = fileMap.get(r.getProcessInstanceId()+r.getNodeId());
                        rspVO.setFileList(Optional.ofNullable(taActFileRespVos).orElse(Lists.newArrayList()));
                    }
                    return rspVO;
                }).collect(Collectors.toList());
                optLogsRspVO.setOptRecordRspVOList(recordRspVOS);
                respVos.add(optLogsRspVO);
            });
        }
        if (CollectionUtils.isNotEmpty(taskList)) {
            ActivitiBusinessEntity activitiBusinessEntity = activitiBusinessEntities.get(0);
            OptLogsRspVO optLogsRspVO = new OptLogsRspVO();
            List<OptRecordRspVO> collect=Lists.newArrayList();
            //要先把当前处理节点的后续节点查询出来放在最前面
            List<TaNodeConfigEntity> nodes=helper.findFutureNodesByProcessVersionKey(activitiBusinessEntity.getProcessVersionKey(),taskList);
            taskList.stream().forEach(o -> {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                //根据任务获取当前任务的审批岗位名称和岗位编码
                helper.setCurrentTaskPosition(rspVO,o);
                rspVO.setCreateTime(new Date());
                rspVO.setTaskDefKey(o.getTaskDefinitionKey());
                rspVO.setTaskName(o.getName());
                rspVO.setTaskId(o.getId());
                rspVO.setProcessVersionKey(o.getProcessDefinitionId());
                rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                rspVO.setContent("当前待办节点");
                rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                rspVO.setId(o.getId());
                rspVO.setOperation("BTN_999");
                rspVO.setOperationStr("待处理");
                rspVO.setUserName(Optional.ofNullable(rspVO.getCurrentAccounts()).orElse(""));
                collect.add(rspVO);
            });
            if(CollectionUtils.isNotEmpty(nodes)){
                nodes.stream().forEach(o->{
                    OptRecordRspVO rspVO = new OptRecordRspVO();
                    rspVO.setTaskDefKey(o.getProcessNodeCode());
                    rspVO.setCreateTime(new Date());
                    rspVO.setTaskName(o.getProcessNodeName());
                    rspVO.setProcessKey(activitiBusinessEntity.getProcessKey());
                    rspVO.setProcessName(activitiBusinessEntity.getProcessName());
                    rspVO.setContent("待处理节点");
                    rspVO.setTitle(activitiBusinessEntity.getProcessTitle());
                    rspVO.setApplierName(activitiBusinessEntity.getCommitName());
                    rspVO.setFormNo(activitiBusinessEntity.getBusinessId());
                    rspVO.setId(o.getId());
                    rspVO.setOperation("BTN_999");
                    rspVO.setOperationStr("待处理");
                    rspVO.setUserName("");
                    collect.add(rspVO);
                });
            }

            //未处理的时间表头都搞成当前时间,后续再商定怎么设值
            String date = DateUtil.formatDate(new Date(), DateUtil.DEFAULT_DAY_PATTERN);
            optLogsRspVO.setLogDate(date);
            optLogsRspVO.setOptRecordRspVOList(collect);
            respVos.add(optLogsRspVO);
        }
        return respVos;
    }
}
