package com.biz.crm.bpmlog.vo;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.biz.crm.sqlupdate.CrmColumn;
import lombok.*;
import lombok.experimental.Accessors;

/**
 * 审批配置主表实体类
 *
 * @author Tao.Chen
 * @date 2021-03-01 17:50:29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ActivitiBpmlogVo extends CrmBaseVo {

    public ActivitiBpmlogVo(String crmProcessInstanceId, String processInstanceId, String businessId,String businessNo,String operateType) {
        this.crmProcessInstanceId = crmProcessInstanceId;
        this.processInstanceId = processInstanceId;
        this.businessId = businessId;
        this.businessNo=businessNo;
        this.operateType = operateType;
    }
    //业务流程编号
    private String crmProcessInstanceId;
    //工作流编号
    private String processInstanceId;

    //枚举 ActivitiOperateTypeEnum 操作类型
    private String operateType;
    //日志流程编号
    private String logCode;
    //操作节点
    private String nodeName;
    //操作id
    private String nodeId;

    /**
     * 操作节点编码
     */
    private String nodeCode;

    /**
     * 任务id
     */
    private String taskId;

    /**
     * 表单id主键
     */
    private String businessId;

    /**
     * 表单编码
     */
    private String businessNo;

    /**
     * 是否系统自动执行(Y/N)
     */
    private String isAutoExecute;

    /**
     * 确认沟通内容
     * */
    private String content;
}
