package com.biz.crm.copy.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.copy.entity.ActivitiCopyTaskEntity;
import com.biz.crm.copy.vo.ActivitiCopyTaskVo;
import com.biz.crm.interceptor.SqlPrivilege;
import org.apache.ibatis.annotations.Param;

import java.util.List;


public interface ActivitiCopyTaskMapper extends BaseMapper<ActivitiCopyTaskEntity> {


    /**
     * 统计我的抄送未读数量
     * @param vo
     * @return
     */
    Integer countMyCopyNoRead(@Param("vo") ActivitiCopyTaskVo vo);

    /**
     * 分页查询抄手列表
     * @param page
     * @param vo
     * @return
     */
    @SqlPrivilege(posCode = "a.create_pos_code",orgCode = "a.create_org_code")
    List<ActivitiCopyTaskVo> listPage(Page<ActivitiCopyTaskVo> page, @Param("vo")ActivitiCopyTaskVo vo);
}
