package com.biz.crm.design.controller;

import com.biz.crm.activiti.mapper.ActReModelMapper;
import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.design.service.DesignService;
import com.biz.crm.design.vo.NewModelVo;
import com.biz.crm.design.vo.SaveModelVo;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Result;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.design.controller
 * @Description: TODO
 * @date 2021/4/14 上午11:41
 */
@Controller
@RequestMapping("/designController")
@Slf4j
public class DesignController{

    @Autowired
    private DesignService designService;

    @Resource
    private RepositoryService repositoryService;

    @Autowired
    private BizRuntimeService bizRuntimeService;
    @Resource
    private ActReModelMapper actReModelMapper;
    /**
     * 新建一个空模型
     * @return
     * @throws UnsupportedEncodingException
     */
    @ResponseBody
    @PostMapping(value = "newModel")
    public Result newModel(@RequestBody NewModelVo newModelVo) {
        String id = designService.newModel(newModelVo);
        return Result.ok(id);
    }
    @GetMapping("editor")
    public ModelAndView modelOpen(){
        ModelAndView model = new ModelAndView("modeler");
        return model;
    }

    @RequestMapping(value="/model/{modelId}/json", method = RequestMethod.GET, produces = "application/json")
    @ResponseBody
    public ObjectNode getEditorJson(@PathVariable String modelId) {
        ObjectNode modelNode = designService.getEditorJson(modelId);
        return modelNode;
    }

    @RequestMapping(value="/editor/stencilset", method = RequestMethod.GET, produces = "application/json;charset=utf-8")
    @ResponseBody
    public String getStencilset(@RequestParam(required = true) String modelId) {
        InputStream stencilsetStream = this.getClass().getClassLoader().getResourceAsStream("stencilset.json");
        try {
            return IOUtils.toString(stencilsetStream, "utf-8");
        } catch (Exception e) {
            throw new ActivitiException("Error while loading stencil set", e);
        }
    }

    @ApiOperation(value = "编辑流程信息")
    @PostMapping(value="/model/{modelId}/save")
    @ResponseStatus(value = HttpStatus.OK)
    public void saveModel(@PathVariable String modelId, @RequestBody SaveModelVo saveModelVo) {
        saveModelVo.setModelId(modelId);
        designService.updateModel(saveModelVo);
    }

    /**
     * 查看流程图
     *
     * @auther: Ace Lee
     * @date: 2019/3/5 15:24
     */

    /**
     * 查看已发布流程图
     * @param deploymentId
     * @throws IOException
     */
    @GetMapping(value = "showPic")
    @ResponseStatus(value = HttpStatus.OK)
    public void showPic(@RequestParam("deploymentId")String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        String ext = ".png";
        if (org.apache.commons.lang3.StringUtils.isEmpty(deploymentId) || org.apache.commons.lang3.StringUtils.isEmpty(ext)){
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition=repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)){
            in = repositoryService.getProcessDiagram(processDefinition.getId());
        }else if (".bpmn".equalsIgnoreCase(ext)){
            in = repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        OutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        } finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * 查看指定版本bpm文件
     * @param deploymentId
     * @throws IOException
     */
    @GetMapping(value = "showBpmn")
    @ResponseStatus(value = HttpStatus.OK)
    public void showBpmn(@RequestParam("deploymentId")String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        httpServletResponse.setContentType("UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        String ext = ".bpmn";
        if (org.apache.commons.lang3.StringUtils.isEmpty(deploymentId) || org.apache.commons.lang3.StringUtils.isEmpty(ext)){
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition=repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)){
            in = repositoryService.getProcessDiagram(processDefinition.getId());
        }else if (".bpmn".equalsIgnoreCase(ext)){
            in = repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        OutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        } finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /**
     * 获取流程图片信息.
     * <p>
     *
     * @throws Exception
     */
    @GetMapping(value = "getProcessPicInfo")
    @ApiOperation(value = "获取流程图片信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "processInstanceId", value = "流程编码", required = false, dataType = "String", paramType = "query")
    })
    @ResponseStatus(value = HttpStatus.OK)
    public void getProcessPicInfo(@RequestParam(value = "processInstanceId",required = true) String processInstanceId) {
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            InputStream is = bizRuntimeService.getProcessInstancePicInfo(processInstanceId);
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
        } catch (Exception e) {
            log.error("", e);
        }
    }


}
